/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.skeleton.key.as7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.Session;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;

public class UserSessionManagement
implements SessionListener {
    private static final Logger log = Logger.getLogger(UserSessionManagement.class);
    protected ConcurrentHashMap<String, Map<String, Session>> userSessionMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void login(Session session, String username) {
        HashMap<String, Session> value;
        HashMap<String, Session> map = this.userSessionMap.get(username);
        if (map == null && (map = (HashMap<String, Session>)this.userSessionMap.putIfAbsent(username, value = new HashMap<String, Session>())) == null) {
            map = value;
        }
        HashMap<String, Session> hashMap = map;
        synchronized (hashMap) {
            map.put(session.getId(), session);
        }
        session.addSessionListener((SessionListener)this);
    }

    public void logoutAll() {
        ArrayList users = new ArrayList();
        users.addAll(this.userSessionMap.keySet());
        for (String user : users) {
            this.logout(user);
        }
    }

    public void logoutAllBut(String but) {
        ArrayList users = new ArrayList();
        users.addAll(this.userSessionMap.keySet());
        for (String user : users) {
            if (but.equals(user)) continue;
            this.logout(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(String user) {
        log.debug((Object)("logoutUser: " + user));
        Map<String, Session> map = this.userSessionMap.remove(user);
        if (map == null) {
            log.debug((Object)("no session for user: " + user));
            return;
        }
        log.debug((Object)"found session for user");
        Map<String, Session> map2 = map;
        synchronized (map2) {
            for (Session session : map.values()) {
                log.debug((Object)("invalidating session for user: " + user));
                session.setPrincipal(null);
                session.setAuthType(null);
                session.getSession().invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEvent(SessionEvent event) {
        if (!"destroySession".equals(event.getType()) && !"passivateSession".equals(event.getType())) {
            return;
        }
        Session session = event.getSession();
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            return;
        }
        session.setPrincipal(null);
        session.setAuthType(null);
        String username = principal.getUserPrincipal().getName();
        Map<String, Session> map = this.userSessionMap.get(username);
        if (map == null) {
            return;
        }
        Map<String, Session> map2 = map;
        synchronized (map2) {
            map.remove(session.getId());
            if (map.isEmpty()) {
                this.userSessionMap.remove(username);
            }
        }
    }
}

