/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.bootstrap.test;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.jandex.Index;
import org.jboss.resteasy.bootstrap.test.TestSslUtil;
import org.jboss.resteasy.bootstrap.test.category.NoSslTests;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public abstract class SeBootstrapTest {
    private SeBootstrap.Instance instance;

    @After
    public void shutdown() throws Exception {
        SeBootstrap.Instance current = this.instance;
        this.instance = null;
        if (current != null) {
            CountDownLatch latch = new CountDownLatch(1);
            current.stop().thenRun(latch::countDown);
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                Assert.fail((String)"Server did not shutdown within 5 seconds");
            }
        }
    }

    @Test
    public void unwrap() throws Exception {
        this.start();
        EmbeddedServer server = (EmbeddedServer)this.instance.unwrap(this.getEmbeddedServerClass());
        Assert.assertNotNull((Object)server);
    }

    @Test
    public void constructedApplication() throws Exception {
        this.start(new DefaultApplication());
        try (Client client = ClientBuilder.newClient();){
            Response response = client.target(this.instance.configuration().baseUriBuilder().path("default/test/constructed")).request().get();
            Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatusInfo());
            Assert.assertEquals((Object)"Hello constructed", (Object)response.readEntity(String.class));
        }
    }

    @Test
    public void bootWithApplication() throws Exception {
        this.start(SeBootstrapApplication1.class);
        EmbeddedServer server = (EmbeddedServer)this.instance.unwrap(this.getEmbeddedServerClass());
        Assert.assertNotNull((Object)server);
        Application application = server.getDeployment().getApplication();
        Assert.assertTrue((String)String.format("Expected %s but found %s", SeBootstrapApplication1.class, application), (boolean)(application instanceof SeBootstrapApplication1));
    }

    @Test
    public void resourceDefined() throws Exception {
        this.start(SeBootstrapApplication1.class);
        try (Client client = ClientBuilder.newClient();){
            Response response = client.target(this.instance.configuration().baseUriBuilder().path("setest1/no-index/defined")).request().get();
            Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatusInfo());
            Assert.assertEquals((Object)"Greetings defined", (Object)response.readEntity(String.class));
            response = client.target(this.instance.configuration().baseUriBuilder().path("setest1/test/skipped")).request().get();
            Assert.assertEquals((Object)Response.Status.NOT_FOUND, (Object)response.getStatusInfo());
        }
    }

    @Test
    public void resourceScanned() throws Exception {
        this.start(SeBootstrapApplication2.class);
        try (Client client = ClientBuilder.newClient();){
            Response response = client.target(this.instance.configuration().baseUriBuilder().path("setest2/test/scanned")).request().get();
            Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatusInfo());
            Assert.assertEquals((Object)"Hello scanned", (Object)response.readEntity(String.class));
        }
    }

    @Test
    public void scanningDisabled() throws Exception {
        this.start(NoScanAnnotation.class);
        try (Client client = ClientBuilder.newClient();){
            Response response = client.target(this.instance.configuration().baseUriBuilder().path("noscan/test/skipped")).request().get();
            Assert.assertEquals((Object)Response.Status.NOT_FOUND, (Object)response.getStatusInfo());
        }
    }

    @Test
    @Category(value={NoSslTests.class})
    public void httpsConnection() throws Exception {
        Index index = Index.of((Class[])new Class[]{TestResource.class});
        this.start(new DefaultApplication(), SeBootstrap.Configuration.builder().property(ConfigurationOption.JANDEX_INDEX.key(), (Object)index).protocol("HTTPS").sslContext(TestSslUtil.createServerSslContext()).build());
        try (Client client = ClientBuilder.newBuilder().sslContext(TestSslUtil.createClientSslContext()).build();){
            Response response = client.target(this.instance.configuration().baseUriBuilder().path("default/test/secure")).request().get();
            Assert.assertEquals((Object)Response.Status.OK, (Object)response.getStatusInfo());
            Assert.assertEquals((Object)"Hello secure", (Object)response.readEntity(String.class));
        }
    }

    protected abstract Class<? extends EmbeddedServer> getEmbeddedServerClass();

    protected void start(Class<? extends Application> application) throws ExecutionException, InterruptedException, TimeoutException, IOException {
        Index index = Index.of((Class[])new Class[]{TestResource.class});
        CompletionStage cs = SeBootstrap.start(application, (SeBootstrap.Configuration)SeBootstrap.Configuration.builder().property(ConfigurationOption.JANDEX_INDEX.key(), (Object)index).build());
        this.instance = (SeBootstrap.Instance)cs.toCompletableFuture().get(60L, TimeUnit.MINUTES);
    }

    protected void start(Application application) throws ExecutionException, InterruptedException, TimeoutException, IOException {
        Index index = Index.of((Class[])new Class[]{TestResource.class});
        this.start(application, SeBootstrap.Configuration.builder().property(ConfigurationOption.JANDEX_INDEX.key(), (Object)index).build());
    }

    protected void start(Application application, SeBootstrap.Configuration configuration) throws ExecutionException, InterruptedException, TimeoutException, IOException {
        CompletionStage cs = SeBootstrap.start((Application)application, (SeBootstrap.Configuration)configuration);
        this.instance = (SeBootstrap.Instance)cs.toCompletableFuture().get(60L, TimeUnit.MINUTES);
    }

    private void start() throws ExecutionException, InterruptedException, TimeoutException, IOException {
        this.start(DefaultApplication.class);
    }

    @Path(value="/no-index")
    public static class NonIndexedResource {
        @GET
        @Path(value="/{name}")
        @Produces(value={"text/plain"})
        public Response greet(@PathParam(value="name") String name) {
            return Response.ok((Object)("Greetings " + name)).build();
        }
    }

    @Path(value="/test")
    public static class TestResource {
        @GET
        @Path(value="/{name}")
        @Produces(value={"text/plain"})
        public Response greet(@PathParam(value="name") String name) {
            return Response.ok((Object)("Hello " + name)).build();
        }
    }

    @ApplicationPath(value="/noscan")
    public static class NoScanAnnotation
    extends Application {
        public Map<String, Object> getProperties() {
            return Collections.singletonMap("jakarta.ws.rs.loadServices", Boolean.FALSE);
        }
    }

    @ApplicationPath(value="/setest2")
    @Priority(value=100)
    public static class SeBootstrapApplication2
    extends Application {
    }

    @ApplicationPath(value="/setest1")
    @Priority(value=500)
    public static class SeBootstrapApplication1
    extends Application {
        public Set<Class<?>> getClasses() {
            return Collections.singleton(NonIndexedResource.class);
        }
    }

    @ApplicationPath(value="/default")
    public static class DefaultApplication
    extends Application {
    }
}

