/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.http.HttpServerRequest;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.util.CookieParser;
import org.jboss.resteasy.util.MediaTypeHelper;

public class VertxUtil {
    public static ResteasyUriInfo extractUriInfo(HttpServerRequest req, String contextPath) {
        Object uriString;
        String protocol;
        String uri = req.absoluteURI();
        if (uri.startsWith((protocol = req.scheme()) + "://")) {
            uriString = uri;
        } else {
            String host = req.host();
            if (host == null) {
                host = "unknown";
            }
            uriString = protocol + "://" + host + uri;
        }
        return new ResteasyUriInfo((String)uriString, contextPath);
    }

    public static ResteasyHttpHeaders extractHttpHeaders(HttpServerRequest request) {
        MultivaluedMap<String, String> requestHeaders = VertxUtil.extractRequestHeaders(request);
        ResteasyHttpHeaders headers = new ResteasyHttpHeaders(requestHeaders);
        Map<String, Cookie> cookies = VertxUtil.extractCookies(requestHeaders);
        headers.setCookies(cookies);
        headers.testParsing();
        return headers;
    }

    static Map<String, Cookie> extractCookies(MultivaluedMap<String, String> headers) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        List cookieHeaders = (List)headers.get((Object)"Cookie");
        if (cookieHeaders == null) {
            return cookies;
        }
        for (String cookieHeader : cookieHeaders) {
            for (Cookie cookie : CookieParser.parseCookies((String)cookieHeader)) {
                cookies.put(cookie.getName(), cookie);
            }
        }
        return cookies;
    }

    public static List<MediaType> extractAccepts(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<MediaType> acceptableMediaTypes = new ArrayList<MediaType>();
        List accepts = (List)requestHeaders.get((Object)"Accept");
        if (accepts == null) {
            return acceptableMediaTypes;
        }
        for (String accept : accepts) {
            acceptableMediaTypes.addAll(MediaTypeHelper.parseHeader((String)accept));
        }
        return acceptableMediaTypes;
    }

    public static List<String> extractLanguages(MultivaluedMap<String, String> requestHeaders) {
        ArrayList<String> acceptable = new ArrayList<String>();
        List accepts = (List)requestHeaders.get((Object)"Accept-Language");
        if (accepts == null) {
            return acceptable;
        }
        for (String accept : accepts) {
            String[] splits;
            for (String split : splits = accept.split(",")) {
                acceptable.add(split.trim());
            }
        }
        return acceptable;
    }

    public static MultivaluedMap<String, String> extractRequestHeaders(HttpServerRequest request) {
        Headers requestHeaders = new Headers();
        for (Map.Entry header : request.headers()) {
            requestHeaders.add((Object)((String)header.getKey()), (Object)((String)header.getValue()));
        }
        return requestHeaders;
    }
}

