/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.server.vertx.VertxHttpResponse;
import org.jboss.resteasy.plugins.server.vertx.i18n.Messages;
import org.jboss.resteasy.spi.AsyncOutputStream;

public class ChunkOutputStream
extends AsyncOutputStream {
    private Buffer buffer;
    private final VertxHttpResponse response;
    private final int chunkSize;

    ChunkOutputStream(VertxHttpResponse response, int chunksize) {
        this.response = response;
        if (chunksize < 1) {
            throw new IllegalArgumentException(Messages.MESSAGES.chunkSizeMustBeAtLeastOne());
        }
        this.chunkSize = chunksize;
        this.buffer = Buffer.buffer((int)chunksize);
    }

    public void write(int b) throws IOException {
        if (this.buffer.length() >= this.chunkSize - 1) {
            this.flush();
        }
        this.buffer.appendByte((byte)b);
    }

    public void reset() {
        if (this.response.isCommitted()) {
            throw new IllegalStateException(Messages.MESSAGES.responseIsCommitted());
        }
        this.buffer = Buffer.buffer((int)this.chunkSize);
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len, null);
    }

    private void write(byte[] b, int off, int len, Handler<AsyncResult<CompositeFuture>> handler) throws IOException {
        int spaceLeftInCurrentChunk;
        int dataLengthLeftToWrite = len;
        int dataToWriteOffset = off;
        ArrayList<Future> futures = handler != null ? new ArrayList<Future>() : null;
        while ((spaceLeftInCurrentChunk = this.chunkSize - this.buffer.length()) < dataLengthLeftToWrite) {
            Promise promise;
            this.buffer.appendBytes(b, dataToWriteOffset, spaceLeftInCurrentChunk);
            dataToWriteOffset += spaceLeftInCurrentChunk;
            dataLengthLeftToWrite -= spaceLeftInCurrentChunk;
            if (handler != null) {
                promise = Promise.promise();
                futures.add(promise.future());
            } else {
                promise = null;
            }
            this.flush((Handler<AsyncResult<Void>>)promise);
        }
        if (dataLengthLeftToWrite > 0) {
            this.buffer.appendBytes(b, dataToWriteOffset, dataLengthLeftToWrite);
        }
        if (handler != null) {
            CompositeFuture.all(futures).onComplete(handler);
        }
    }

    public void flush() throws IOException {
        this.flush(null);
    }

    private void flush(Handler<AsyncResult<Void>> handler) throws IOException {
        int readable = this.buffer.length();
        if (readable == 0) {
            if (handler != null) {
                handler.handle((Object)Future.succeededFuture());
            }
            return;
        }
        if (!this.response.isCommitted()) {
            this.response.prepareChunkStream();
        }
        this.response.checkException();
        this.response.response.write((Object)this.buffer, handler);
        this.buffer = Buffer.buffer();
        super.flush();
    }

    public CompletionStage<Void> asyncFlush() {
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        try {
            this.flush((Handler<AsyncResult<Void>>)((Handler)res -> {
                if (res.succeeded()) {
                    ret.complete(null);
                } else {
                    ret.completeExceptionally(res.cause());
                }
            }));
        }
        catch (IOException e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }

    public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        try {
            this.write(bytes, offset, length, (Handler<AsyncResult<CompositeFuture>>)((Handler)res -> {
                if (res.succeeded()) {
                    ret.complete(null);
                } else {
                    ret.completeExceptionally(res.cause());
                }
            }));
        }
        catch (IOException e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }
}

