/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.vertx;

import io.vertx.core.Context;
import io.vertx.core.http.HttpServerRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.plugins.server.vertx.VertxHttpResponse;
import org.jboss.resteasy.plugins.server.vertx.VertxUtil;
import org.jboss.resteasy.plugins.server.vertx.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.RunnableWithException;

public class VertxHttpRequest
extends BaseHttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected SynchronousDispatcher dispatcher;
    protected String httpMethod;
    protected InputStream inputStream;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected VertxHttpResponse response;
    private final boolean is100ContinueExpected;
    private VertxExecutionContext executionContext;
    private final Context context;
    private volatile boolean flushed;
    private HttpServerRequest request;

    public VertxHttpRequest(Context context, HttpServerRequest request, ResteasyUriInfo uri, SynchronousDispatcher dispatcher, VertxHttpResponse response, boolean is100ContinueExpected) {
        super(uri);
        this.context = context;
        this.is100ContinueExpected = is100ContinueExpected;
        this.response = response;
        this.request = request;
        this.dispatcher = dispatcher;
        this.httpHeaders = VertxUtil.extractHttpHeaders(request);
        this.httpMethod = request.method().name();
        this.executionContext = new VertxExecutionContext(this, response, dispatcher);
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = VertxHttpRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return this.executionContext;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public VertxHttpResponse getResponse() {
        return this.response;
    }

    public boolean is100ContinueExpected() {
        return this.is100ContinueExpected;
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }

    public String getRemoteHost() {
        return this.request.remoteAddress().host();
    }

    public String getRemoteAddress() {
        return this.request.remoteAddress().host();
    }

    class VertxExecutionContext
    extends AbstractExecutionContext {
        protected final VertxHttpRequest request;
        protected final VertxHttpResponse response;
        protected volatile boolean done;
        protected volatile boolean cancelled;
        protected volatile boolean wasSuspended;
        protected VertxHttpAsyncResponse asyncResponse;

        VertxExecutionContext(VertxHttpRequest request, VertxHttpResponse response, SynchronousDispatcher dispatcher) {
            super(dispatcher, (HttpRequest)request, (HttpResponse)response);
            this.request = request;
            this.response = response;
            this.asyncResponse = new VertxHttpAsyncResponse(dispatcher, request, response);
        }

        public boolean isSuspended() {
            return this.wasSuspended;
        }

        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asyncResponse;
        }

        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            if (this.wasSuspended) {
                throw new IllegalStateException(Messages.MESSAGES.alreadySuspended());
            }
            this.wasSuspended = true;
            return this.asyncResponse;
        }

        public void complete() {
            if (this.wasSuspended && this.asyncResponse != null) {
                this.asyncResponse.complete();
            }
        }

        public CompletionStage<Void> executeAsyncIo(CompletionStage<Void> f) {
            CompletableFuture<Void> ret = f.toCompletableFuture();
            if (!ret.isDone() && !this.isSuspended()) {
                this.suspend();
            }
            return ret;
        }

        public CompletionStage<Void> executeBlockingIo(RunnableWithException f, boolean hasInterceptors) {
            if (!Context.isOnEventLoopThread()) {
                try {
                    f.run();
                }
                catch (Exception e) {
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    ret.completeExceptionally(e);
                    return ret;
                }
                return CompletableFuture.completedFuture(null);
            }
            if (!hasInterceptors) {
                Map context = ResteasyContext.getContextDataMap();
                if (!this.isSuspended()) {
                    this.suspend();
                }
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                this.request.context.executeBlocking(future -> {
                    try (ResteasyContext.CloseableContext newContext = ResteasyContext.addCloseableContextDataLevel((Map)context);){
                        f.run();
                        future.complete();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, res -> {
                    if (res.succeeded()) {
                        ret.complete(null);
                    } else {
                        ret.completeExceptionally(res.cause());
                    }
                });
                return ret;
            }
            CompletableFuture<Void> ret = new CompletableFuture<Void>();
            ret.completeExceptionally(new RuntimeException("Cannot use blocking IO with interceptors when we're on the IO thread"));
            return ret;
        }

        class VertxHttpAsyncResponse
        extends AbstractAsynchronousResponse {
            private final Object responseLock;
            private long timerID;
            private VertxHttpResponse vertxResponse;

            VertxHttpAsyncResponse(SynchronousDispatcher dispatcher, VertxHttpRequest request, VertxHttpResponse response) {
                super(dispatcher, (HttpRequest)request, (HttpResponse)response);
                this.responseLock = new Object();
                this.timerID = -1L;
                this.vertxResponse = response;
            }

            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done) {
                        return;
                    }
                    if (VertxExecutionContext.this.cancelled) {
                        return;
                    }
                    VertxExecutionContext.this.done = true;
                    this.vertxFlush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    if (VertxExecutionContext.this.cancelled) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    return this.internalResume(entity, t -> this.vertxFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Throwable ex) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    if (VertxExecutionContext.this.cancelled) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    return this.internalResume(ex, t -> this.vertxFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build(), t -> this.vertxFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(int retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), t -> this.vertxFlush());
                }
            }

            protected synchronized void vertxFlush() {
                VertxHttpRequest.this.flushed = true;
                try {
                    this.vertxResponse.finish();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(Date retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (VertxExecutionContext.this.done) {
                        return false;
                    }
                    VertxExecutionContext.this.done = true;
                    VertxExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), t -> this.vertxFlush());
                }
            }

            public boolean isSuspended() {
                return !VertxExecutionContext.this.done && !VertxExecutionContext.this.cancelled;
            }

            public boolean isCancelled() {
                return VertxExecutionContext.this.cancelled;
            }

            public boolean isDone() {
                return VertxExecutionContext.this.done;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTimeout(long time, TimeUnit unit) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (VertxExecutionContext.this.done || VertxExecutionContext.this.cancelled) {
                        return false;
                    }
                    if (this.timerID > -1L && !VertxHttpRequest.this.context.owner().cancelTimer(this.timerID)) {
                        return false;
                    }
                    this.timerID = VertxHttpRequest.this.context.owner().setTimer(unit.toMillis(time), v -> this.handleTimeout());
                }
                return true;
            }

            protected void handleTimeout() {
                if (this.timeoutHandler != null) {
                    this.timeoutHandler.handleTimeout((AsyncResponse)this);
                    return;
                }
                if (VertxExecutionContext.this.done) {
                    return;
                }
                this.resume((Throwable)new ServiceUnavailableException());
            }
        }
    }
}

