/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.hibernate.validator.internal.metadata.descriptor.ConstraintDescriptorImpl;

public class SimpleViolationsContainer
extends org.jboss.resteasy.api.validation.SimpleViolationsContainer
implements Serializable {
    private static final long serialVersionUID = -7895854137980651539L;

    public SimpleViolationsContainer(Object target) {
        super(target);
    }

    public SimpleViolationsContainer(Set<ConstraintViolation<Object>> cvs) {
        super(cvs);
    }

    public void addViolations(Set<ConstraintViolation<Object>> cvs) {
        if (cvs.size() == 0) {
            return;
        }
        if (this.getViolations().size() == 0) {
            this.getViolations().addAll(cvs);
            return;
        }
        boolean skip = false;
        for (ConstraintViolation<Object> cv1 : cvs) {
            skip = false;
            for (ConstraintViolation cv2 : this.getViolations()) {
                if (!SimpleViolationsContainer.compareConstraintViolation(cv1, cv2)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            this.getViolations().add(cv1);
        }
    }

    static boolean compareConstraintViolation(ConstraintViolation<?> cv1, ConstraintViolation<?> cv2) {
        if (cv1 == cv2) {
            return true;
        }
        if (cv1 == null || cv2 == null) {
            return false;
        }
        if (cv1.getMessage() != null ? !cv1.getMessage().equals(cv2.getMessage()) : cv2.getMessage() != null) {
            return false;
        }
        if (cv1.getPropertyPath() != null ? !SimpleViolationsContainer.comparePropertyPath(cv1.getPropertyPath(), cv2.getPropertyPath()) : cv2.getPropertyPath() != null) {
            return false;
        }
        if (cv1.getRootBeanClass() != null ? !SimpleViolationsContainer.compareRootBeanClass(cv1, cv2) : cv2.getRootBeanClass() != null) {
            return false;
        }
        if (cv1.getLeafBean() != null ? !SimpleViolationsContainer.compareLeafBeanClass(cv1, cv2) : cv2.getLeafBean() != null) {
            return false;
        }
        if (cv1.getConstraintDescriptor() != null ? !cv1.getConstraintDescriptor().equals(cv2.getConstraintDescriptor()) : cv2.getConstraintDescriptor() != null) {
            return false;
        }
        if (cv1.getConstraintDescriptor() instanceof ConstraintDescriptorImpl && cv2.getConstraintDescriptor() instanceof ConstraintDescriptorImpl) {
            ConstraintDescriptorImpl cdi1 = (ConstraintDescriptorImpl)cv1.getConstraintDescriptor();
            ConstraintDescriptorImpl cdi2 = (ConstraintDescriptorImpl)cv2.getConstraintDescriptor();
            if (cdi1.getElementType() != null ? !cdi1.getElementType().equals((Object)cdi2.getElementType()) : cdi2.getElementType() != null) {
                return false;
            }
        }
        if (cv1.getMessageTemplate() != null ? !cv1.getMessageTemplate().equals(cv2.getMessageTemplate()) : cv2.getMessageTemplate() != null) {
            return false;
        }
        return !(cv1.getInvalidValue() != null ? !cv1.getInvalidValue().equals(cv2.getInvalidValue()) : cv2.getInvalidValue() != null);
    }

    private static boolean compareRootBeanClass(ConstraintViolation<?> cv1, ConstraintViolation<?> cv2) {
        Class c1 = cv1.getRootBeanClass();
        while ((c1.isSynthetic() || SimpleViolationsContainer.isEJBProxy(c1)) && !Object.class.equals((Object)c1)) {
            c1 = c1.getSuperclass();
        }
        Class c2 = cv2.getRootBeanClass();
        while ((c2.isSynthetic() || SimpleViolationsContainer.isEJBProxy(c2)) && !Object.class.equals((Object)c2)) {
            c2 = c2.getSuperclass();
        }
        return c1.equals(c2);
    }

    private static boolean compareLeafBeanClass(ConstraintViolation<?> cv1, ConstraintViolation<?> cv2) {
        Object o1 = cv1.getLeafBean();
        Class<?> c1 = o1.getClass();
        while ((c1.isSynthetic() || SimpleViolationsContainer.isEJBProxy(c1)) && !Object.class.equals(c1)) {
            c1 = c1.getSuperclass();
        }
        Object o2 = cv2.getLeafBean();
        Class<?> c2 = o2.getClass();
        while ((c2.isSynthetic() || SimpleViolationsContainer.isEJBProxy(c2)) && !Object.class.equals(c2)) {
            c2 = c2.getSuperclass();
        }
        return c1.equals(c2);
    }

    private static boolean comparePropertyPath(Path p1, Path p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.getClass() != p2.getClass()) {
            return false;
        }
        Iterator it1 = p1.iterator();
        Iterator it2 = p2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (SimpleViolationsContainer.compareNode((Path.Node)it1.next(), (Path.Node)it2.next())) continue;
            return false;
        }
        return it1.hasNext() == it2.hasNext();
    }

    private static boolean compareNode(Path.Node n1, Path.Node n2) {
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        if (n1.getClass() != n2.getClass()) {
            return false;
        }
        if (!(n1 instanceof NodeImpl)) {
            return false;
        }
        NodeImpl ni1 = (NodeImpl)n1;
        NodeImpl ni2 = (NodeImpl)n2;
        if (ni1.getIndex() == null ? ni2.getIndex() != null : !ni1.getIndex().equals(ni2.getIndex())) {
            return false;
        }
        if (ni1.isInIterable() != ni2.isInIterable()) {
            return false;
        }
        if (ni1.getKey() == null ? ni2.getKey() != null : !ni1.getKey().equals(ni2.getKey())) {
            return false;
        }
        if (ni1.getKind() != ni2.getKind()) {
            return false;
        }
        if (ni1.getName() == null ? ni2.getName() != null : !ni1.getName().equals(ni2.getName())) {
            return false;
        }
        if (ni1.getKind().equals((Object)ElementKind.PARAMETER) && ni2.getKind().equals((Object)ElementKind.PARAMETER) && ni1.getParameterIndex() != ni2.getParameterIndex()) {
            return false;
        }
        if (ni1.getParameterTypes() == null ? ni2.getParameterTypes() != null : !SimpleViolationsContainer.compareClassList(ni1.getParameterTypes(), ni2.getParameterTypes())) {
            return false;
        }
        return !(ni1.getParent() == null ? ni2.getParent() != null : !SimpleViolationsContainer.compareNode((Path.Node)ni1.getParent(), (Path.Node)ni2.getParent()));
    }

    private static boolean compareClassList(List<Class<?>> l1, List<Class<?>> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (l1.get(i) == l2.get(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean isEJBProxy(Class<?> clazz) {
        return clazz.getName().contains("$$$view");
    }
}

