/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.validation.GeneralValidatorImpl;
import org.jboss.resteasy.spi.validation.GeneralValidator;

@Provider
public class ValidatorContextResolver
implements ContextResolver<GeneralValidator> {
    private static final Logger logger = Logger.getLogger(ValidatorContextResolver.class);
    private static volatile ValidatorFactory validatorFactory;
    static final Object RD_LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ValidatorFactory getValidatorFactory() {
        ValidatorFactory tmpValidatorFactory = validatorFactory;
        if (tmpValidatorFactory == null) {
            Object object = RD_LOCK;
            synchronized (object) {
                tmpValidatorFactory = validatorFactory;
                if (tmpValidatorFactory == null) {
                    try {
                        InitialContext context = new InitialContext();
                        validatorFactory = tmpValidatorFactory = (ValidatorFactory)ValidatorFactory.class.cast(context.lookup("java:comp/ValidatorFactory"));
                        logger.debug("Using CDI supporting " + validatorFactory);
                    }
                    catch (NamingException e) {
                        logger.info("Unable to find CDI supporting ValidatorFactory. Using default ValidatorFactory");
                        HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure();
                        validatorFactory = tmpValidatorFactory = config.buildValidatorFactory();
                    }
                }
            }
        }
        return validatorFactory;
    }

    public GeneralValidator getContext(Class<?> type) {
        try {
            Validator validator = ValidatorContextResolver.getValidatorFactory().getValidator();
            Configuration config = Validation.byDefaultProvider().configure();
            BootstrapConfiguration bootstrapConfiguration = config.getBootstrapConfiguration();
            boolean isExecutableValidationEnabled = bootstrapConfiguration.isExecutableValidationEnabled();
            Set defaultValidatedExecutableTypes = bootstrapConfiguration.getDefaultValidatedExecutableTypes();
            return new GeneralValidatorImpl(validator, isExecutableValidationEnabled, defaultValidatedExecutableTypes);
        }
        catch (Exception e) {
            logger.warn("Unable to load Validation support", (Throwable)e);
            return null;
        }
    }

    static {
        RD_LOCK = new Object();
    }
}

