/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.undertow;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import java.util.Map;
import javax.servlet.ServletException;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.core.ResteasyDeploymentImpl;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.PortProvider;

public class UndertowJaxrsServer {
    protected final PathHandler root = new PathHandler();
    protected final ServletContainer container = ServletContainer.Factory.newInstance();
    protected Undertow server;
    protected DeploymentManager manager;

    public DeploymentInfo undertowDeployment(ResteasyDeployment deployment, String mapping) {
        if (mapping == null) {
            mapping = "/";
        }
        if (!mapping.startsWith("/")) {
            mapping = "/" + mapping;
        }
        if (!mapping.endsWith("/")) {
            mapping = mapping + "/";
        }
        mapping = mapping + "*";
        String prefix = null;
        if (!mapping.equals("/*")) {
            prefix = mapping.substring(0, mapping.length() - 2);
        }
        ServletInfo resteasyServlet = Servlets.servlet((String)"ResteasyServlet", HttpServlet30Dispatcher.class).setAsyncSupported(true).setLoadOnStartup(Integer.valueOf(1)).addMapping(mapping);
        if (prefix != null) {
            resteasyServlet.addInitParam("resteasy.servlet.mapping.prefix", prefix);
        }
        return new DeploymentInfo().addServletContextAttribute(ResteasyDeployment.class.getName(), (Object)deployment).addServlet(resteasyServlet);
    }

    public DeploymentInfo undertowDeployment(ResteasyDeployment deployment) {
        return this.undertowDeployment(deployment, "/");
    }

    public DeploymentInfo undertowDeployment(Class<? extends Application> application, String mapping) {
        ResteasyDeploymentImpl deployment = new ResteasyDeploymentImpl();
        deployment.setApplicationClass(application.getName());
        DeploymentInfo di = this.undertowDeployment((ResteasyDeployment)deployment, mapping);
        di.setClassLoader(application.getClassLoader());
        return di;
    }

    public DeploymentInfo undertowDeployment(Class<? extends Application> application) {
        ApplicationPath appPath = application.getAnnotation(ApplicationPath.class);
        String path = "/";
        if (appPath != null) {
            path = appPath.value();
        }
        return this.undertowDeployment(application, path);
    }

    public void addResourcePrefixPath(String path, ResourceHandler handler) {
        this.root.addPrefixPath(path, (HttpHandler)handler);
    }

    public UndertowJaxrsServer deploy(ResteasyDeployment deployment) {
        return this.deploy(deployment, "/");
    }

    public UndertowJaxrsServer deploy(ResteasyDeployment deployment, String contextPath) {
        return this.deploy(deployment, contextPath, null, null);
    }

    public UndertowJaxrsServer deploy(ResteasyDeployment deployment, String contextPath, Map<String, String> contextParams, Map<String, String> initParams) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        DeploymentInfo builder = this.undertowDeployment(deployment);
        builder.setContextPath(contextPath);
        builder.setDeploymentName("Resteasy" + contextPath);
        builder.setClassLoader(deployment.getApplication().getClass().getClassLoader());
        if (contextParams != null) {
            for (Map.Entry<String, String> e : contextParams.entrySet()) {
                builder.addInitParameter(e.getKey(), e.getValue());
            }
        }
        if (initParams != null) {
            ServletInfo servletInfo = (ServletInfo)builder.getServlets().get("ResteasyServlet");
            for (Map.Entry<String, String> e : initParams.entrySet()) {
                servletInfo.addInitParam(e.getKey(), e.getValue());
            }
        }
        return this.deploy(builder);
    }

    public UndertowJaxrsServer deploy(Class<? extends Application> application) {
        ApplicationPath appPath = application.getAnnotation(ApplicationPath.class);
        String path = "/";
        if (appPath != null) {
            path = appPath.value();
        }
        return this.deploy(application, path);
    }

    public UndertowJaxrsServer deploy(Class<? extends Application> application, String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        ResteasyDeploymentImpl deployment = new ResteasyDeploymentImpl();
        deployment.setApplicationClass(application.getName());
        DeploymentInfo di = this.undertowDeployment((ResteasyDeployment)deployment);
        di.setClassLoader(application.getClassLoader());
        di.setContextPath(contextPath);
        di.setDeploymentName("Resteasy" + contextPath);
        return this.deploy(di);
    }

    public UndertowJaxrsServer deploy(Application application) {
        ApplicationPath appPath = application.getClass().getAnnotation(ApplicationPath.class);
        String path = "/";
        if (appPath != null) {
            path = appPath.value();
        }
        return this.deploy(application, path);
    }

    public UndertowJaxrsServer deploy(Application application, String contextPath) {
        if (contextPath == null) {
            contextPath = "/";
        }
        if (!contextPath.startsWith("/")) {
            contextPath = "/" + contextPath;
        }
        ResteasyDeploymentImpl deployment = new ResteasyDeploymentImpl();
        deployment.setApplication(application);
        DeploymentInfo di = this.undertowDeployment((ResteasyDeployment)deployment);
        di.setClassLoader(application.getClass().getClassLoader());
        di.setContextPath(contextPath);
        di.setDeploymentName("Resteasy" + contextPath);
        return this.deploy(di);
    }

    public UndertowJaxrsServer deploy(DeploymentInfo builder) {
        this.manager = this.container.addDeployment(builder);
        this.manager.deploy();
        try {
            this.root.addPrefixPath(builder.getContextPath(), this.manager.start());
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public UndertowJaxrsServer start(Undertow.Builder builder) {
        this.server = builder.setHandler((HttpHandler)this.root).build();
        this.server.start();
        return this;
    }

    public UndertowJaxrsServer start() {
        this.server = Undertow.builder().addHttpListener(PortProvider.getPort(), "localhost").setHandler((HttpHandler)this.root).build();
        this.server.start();
        return this;
    }

    public void stop() {
        this.server.stop();
    }

    public DeploymentManager getManager() {
        return this.manager;
    }
}

