/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import javax.servlet.http.HttpServletRequest;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodRegistry;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.springmvc.RequestUtil;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

public class ResteasyHandlerMapping
implements HandlerMapping,
Ordered {
    private int order = -1;
    private ResourceMethodRegistry registry;
    private String prefix = "";
    private HandlerInterceptor[] interceptors;

    public ResteasyHandlerMapping(ResourceMethodRegistry registry) {
        this.registry = registry;
    }

    public void setRegistry(ResourceMethodRegistry registry) {
        this.registry = registry;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public HandlerInterceptor[] getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(HandlerInterceptor[] interceptors) {
        this.interceptors = interceptors;
    }

    public ResourceMethodRegistry getRegistry() {
        return this.registry;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        try {
            ResteasyRequestWrapper responseWrapper = RequestUtil.getRequestWrapper(request, request.getMethod(), this.prefix);
            ResourceInvoker invoker = this.registry.getResourceInvoker(responseWrapper.getHttpRequest(), null);
            if (invoker == null) {
                return null;
            }
            responseWrapper.setInvoker(invoker);
            return new HandlerExecutionChain((Object)responseWrapper, this.interceptors);
        }
        catch (Failure e) {
            return null;
        }
    }

    public int getOrder() {
        return this.order;
    }
}

