/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.ResponseInvoker;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.specimpl.ResponseImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.springmvc.RequestUtil;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyWebHandlerTemplate;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyView
implements View {
    private MediaType contentType = null;
    private List<MediaType> potentialContentTypes = null;
    private SynchronousDispatcher dispatcher;

    public ResteasyView(String contentType, SynchronousDispatcher dispatcher) {
        this.setContentType(contentType);
        this.setDispatcher(dispatcher);
    }

    public ResteasyView() {
    }

    public SynchronousDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public void setDispatcher(SynchronousDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public List<String> getPotentialContentTypes() {
        ArrayList<String> contentTypes = new ArrayList<String>(this.potentialContentTypes.size());
        for (MediaType mediaType : this.potentialContentTypes) {
            contentTypes.add(mediaType.toString());
        }
        return contentTypes;
    }

    public void setPotentialContentTypes(List<String> potentialContentTypes) {
        this.potentialContentTypes = new ArrayList<MediaType>();
        for (String type : potentialContentTypes) {
            this.potentialContentTypes.add(MediaType.valueOf((String)type));
        }
    }

    public void render(final Map model, HttpServletRequest servletRequest, final HttpServletResponse servletResponse) throws Exception {
        ResteasyWebHandlerTemplate<Void> template = new ResteasyWebHandlerTemplate<Void>(this.dispatcher){

            @Override
            protected Void handle(ResteasyRequestWrapper requestWrapper, HttpResponse response) throws Exception {
                HttpRequest httpRequest = requestWrapper.getHttpRequest();
                try {
                    ResponseInvoker responseInvoker;
                    MediaType resolvedContentType = ResteasyView.this.resolveContentType(httpRequest, httpRequest.getHttpHeaders().getMediaType());
                    if (resolvedContentType != null) {
                        servletResponse.setContentType(resolvedContentType.toString());
                    }
                    if ((responseInvoker = ResteasyView.this.getResponse(model, resolvedContentType)) != null) {
                        if (responseInvoker.getWriter() == null) {
                            String message = "Could not find MessageBodyWriter for response object of type: %s of media type: %s";
                            throw new LoggableFailure(String.format(message, responseInvoker.getType().getName(), resolvedContentType), 500);
                        }
                        responseInvoker.writeTo(response);
                    }
                }
                catch (Exception e) {
                    this.dispatcher.handleWriteResponseException(httpRequest, response, e);
                }
                return null;
            }
        };
        ResteasyRequestWrapper requestWrapper = RequestUtil.getRequestWrapper(servletRequest);
        template.handle(requestWrapper, servletResponse);
    }

    private MediaType resolveContentType(HttpRequest jaxrsRequest, MediaType mt) {
        if (mt == null || "*".equals(mt.getType())) {
            List acceptableMediaTypes = jaxrsRequest.getHttpHeaders().getAcceptableMediaTypes();
            if (this.contentType != null && this.isAcceptable(acceptableMediaTypes, this.contentType)) {
                return this.contentType;
            }
            return MediaTypeHelper.getBestMatch(this.potentialContentTypes, (List)acceptableMediaTypes);
        }
        return mt;
    }

    private boolean isAcceptable(List<MediaType> acceptableMediaTypes, MediaType potentialContentType) {
        boolean isAcceptable = false;
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(potentialContentType)) continue;
            isAcceptable = true;
            break;
        }
        return isAcceptable;
    }

    protected ResponseInvoker getResponse(Map model, MediaType mt) {
        Collection modelValues = model.values();
        for (Object value : modelValues) {
            if (!(value instanceof ResponseInvoker)) continue;
            return (ResponseInvoker)value;
        }
        if (model.size() == 1) {
            return this.createResponseInvoker(modelValues.iterator().next(), mt);
        }
        if (model.size() == 2) {
            for (Object value : modelValues) {
                if (value instanceof BindingResult) continue;
                return this.createResponseInvoker(value, mt);
            }
        }
        return null;
    }

    private ResponseInvoker createResponseInvoker(Object value, MediaType contentType) {
        ResponseImpl responseImpl = new ResponseImpl();
        responseImpl.setEntity(value);
        if (contentType != null) {
            responseImpl.getMetadata().putSingle((Object)"Content-Type", (Object)contentType);
        }
        return this.dispatcher.getDispatcherUtilities().createResponseInvoker((Response)responseImpl);
    }

    public void setContentType(String contentType) {
        this.contentType = MediaType.valueOf((String)contentType);
    }
}

