/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.Parameter;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.util.FindAnnotation;
import org.jboss.resteasy.spi.util.Types;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

public class SpringResourceBuilder
extends ResourceBuilder {
    public Class<? extends Annotation> getCorrespondingRootAnnotation() {
        return RestController.class;
    }

    protected ResourceBuilder.ResourceClassBuilder createResourceClassBuilder(Class<?> clazz) {
        String[] paths;
        RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
        if (requestMapping != null && (paths = SpringResourceBuilder.getPath(requestMapping)) != null && paths.length > 0) {
            return new SpringResourceClassBuilder(clazz, paths[0]);
        }
        return new SpringResourceClassBuilder(clazz, "/");
    }

    protected void processMethod(boolean isLocator, ResourceBuilder.ResourceClassBuilder resourceClassBuilder, Class<?> root, Method implementation) {
        Method method = this.getAnnotatedMethod(root, implementation);
        Set<String> httpMethods = SpringResourceBuilder.getHttpMethods(method);
        if (method != null && httpMethods != null) {
            String methodPath;
            ResourceBuilder.ResourceMethodBuilder resourceMethodBuilder = resourceClassBuilder.method(implementation, method);
            for (String httpMethod : httpMethods) {
                if (httpMethod.equalsIgnoreCase(RequestMethod.GET.name())) {
                    resourceMethodBuilder.get();
                    continue;
                }
                if (httpMethod.equalsIgnoreCase(RequestMethod.PUT.name())) {
                    resourceMethodBuilder.put();
                    continue;
                }
                if (httpMethod.equalsIgnoreCase(RequestMethod.POST.name())) {
                    resourceMethodBuilder.post();
                    continue;
                }
                if (httpMethod.equalsIgnoreCase(RequestMethod.DELETE.name())) {
                    resourceMethodBuilder.delete();
                    continue;
                }
                if (httpMethod.equalsIgnoreCase(RequestMethod.OPTIONS.name())) {
                    resourceMethodBuilder.options();
                    continue;
                }
                if (httpMethod.equalsIgnoreCase(RequestMethod.HEAD.name())) {
                    resourceMethodBuilder.head();
                    continue;
                }
                resourceMethodBuilder.httpMethod(httpMethod);
            }
            this.handleProduces(resourceClassBuilder, method, resourceMethodBuilder);
            this.handleConsumes(resourceClassBuilder, method, resourceMethodBuilder);
            RequestMappingData methodRequestMapping = SpringResourceBuilder.getRequestMapping(method);
            if (methodRequestMapping != null && (methodPath = methodRequestMapping.getFirstPath()) != null) {
                resourceMethodBuilder.path(this.replaceSpringWebWildcards(methodPath));
            }
            for (int i = 0; i < resourceMethodBuilder.getLocator().getParams().length; ++i) {
                resourceMethodBuilder.param(i).fromAnnotations();
            }
            resourceMethodBuilder.buildMethod();
        }
    }

    private String replaceSpringWebWildcards(String methodPath) {
        String[] parts;
        if (methodPath.contains("/**")) {
            methodPath = methodPath.replace("/**", "{unsetPlaceHolderVar:.*}");
        }
        if (methodPath.contains("/*")) {
            methodPath = methodPath.replace("/*", "/{unusedPlaceHolderVar}");
        }
        if ((parts = methodPath.split("/")).length > 0) {
            StringBuilder sb = new StringBuilder(methodPath.startsWith("/") ? "/" : "");
            for (String part : parts) {
                if (part.isEmpty()) continue;
                if (!sb.toString().endsWith("/")) {
                    sb.append("/");
                }
                if (part.startsWith("{") && part.endsWith("}") || !part.contains("?")) {
                    sb.append(part);
                    continue;
                }
                sb.append("{notusedPlaceHolderVar:").append(part.replace('?', '.')).append("}");
            }
            if (methodPath.endsWith("/")) {
                sb.append("/");
            }
            methodPath = sb.toString();
        }
        return methodPath;
    }

    private void handleConsumes(ResourceBuilder.ResourceClassBuilder resourceClassBuilder, Method method, ResourceBuilder.ResourceMethodBuilder resourceMethodBuilder) {
        RequestMappingData requestMapping = this.getRequestMapping(resourceClassBuilder, method);
        if (requestMapping != null && requestMapping.getConsumes().length > 0) {
            resourceMethodBuilder.consumes(requestMapping.getConsumes());
        }
    }

    private void handleProduces(ResourceBuilder.ResourceClassBuilder resourceClassBuilder, Method method, ResourceBuilder.ResourceMethodBuilder resourceMethodBuilder) {
        RequestMappingData requestMapping = this.getRequestMapping(resourceClassBuilder, method);
        if (requestMapping != null && requestMapping.getProduces().length > 0) {
            resourceMethodBuilder.produces(requestMapping.getProduces());
        } else if (!String.class.equals(method.getReturnType()) && !Void.TYPE.equals(method.getReturnType())) {
            resourceMethodBuilder.produces(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        }
    }

    private RequestMappingData getRequestMapping(ResourceBuilder.ResourceClassBuilder resourceClassBuilder, Method method) {
        RequestMappingData requestMapping = SpringResourceBuilder.getRequestMapping(method);
        if (requestMapping == null) {
            requestMapping = SpringResourceBuilder.getRequestMapping(resourceClassBuilder.resourceClass.getClazz());
        }
        if (requestMapping == null) {
            requestMapping = SpringResourceBuilder.getRequestMapping(method.getDeclaringClass());
        }
        return requestMapping;
    }

    public Method getAnnotatedMethod(Class<?> root, Method implementation) {
        Method overriddenMethod;
        Class<?> clazz;
        if (implementation.isSynthetic()) {
            return null;
        }
        if (SpringResourceBuilder.getHttpMethods(implementation) != null) {
            return implementation;
        }
        for (clazz = implementation.getDeclaringClass().getSuperclass(); clazz != null; clazz = clazz.getSuperclass()) {
            overriddenMethod = Types.findOverriddenMethod(implementation.getDeclaringClass(), clazz, (Method)implementation);
            if (overriddenMethod == null || SpringResourceBuilder.getHttpMethods(overriddenMethod) == null) continue;
            return overriddenMethod;
        }
        for (clazz = root; clazz != null; clazz = clazz.getSuperclass()) {
            overriddenMethod = null;
            for (Class<?> classInterface : clazz.getInterfaces()) {
                Method overriddenInterfaceMethod = Types.getImplementedInterfaceMethod(root, classInterface, (Method)implementation);
                if (overriddenInterfaceMethod == null || SpringResourceBuilder.getHttpMethods(overriddenInterfaceMethod) == null) continue;
                if (overriddenMethod != null && !overriddenInterfaceMethod.equals(overriddenMethod)) {
                    throw new RuntimeException(Messages.MESSAGES.ambiguousInheritedAnnotations(implementation));
                }
                overriddenMethod = overriddenInterfaceMethod;
            }
            if (overriddenMethod == null) continue;
            return overriddenMethod;
        }
        return null;
    }

    private static Set<String> getHttpMethods(Method method) {
        RequestMethod[] methodsFromAnnotation;
        RequestMappingData requestMapping = SpringResourceBuilder.getRequestMapping(method);
        if (requestMapping == null) {
            return null;
        }
        HashSet<String> methods = new HashSet<String>();
        for (RequestMethod requestMethod : methodsFromAnnotation = requestMapping.getMethod().length == 0 ? RequestMethod.values() : requestMapping.getMethod()) {
            methods.add(requestMethod.name());
        }
        return methods;
    }

    private static RequestMappingData getRequestMapping(Method method) {
        RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            return RequestMappingData.fromRequestMapping(requestMapping);
        }
        for (Annotation annotation : method.getAnnotations()) {
            requestMapping = annotation.annotationType().getAnnotation(RequestMapping.class);
            if (requestMapping == null) continue;
            return RequestMappingData.fromAnnotation(annotation);
        }
        return null;
    }

    private static RequestMappingData getRequestMapping(Class<?> clazz) {
        RequestMapping requestMapping = clazz.getAnnotation(RequestMapping.class);
        if (requestMapping != null) {
            return RequestMappingData.fromRequestMapping(requestMapping);
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            requestMapping = annotation.annotationType().getAnnotation(RequestMapping.class);
            if (requestMapping == null) continue;
            return RequestMappingData.fromAnnotation(annotation);
        }
        return null;
    }

    private static String[] getPath(RequestMapping requestMapping) {
        return SpringResourceBuilder.getPath(requestMapping.path(), requestMapping.value());
    }

    private static String[] getPath(String[] path, String[] value) {
        if (path.length > 0) {
            return path;
        }
        return value;
    }

    private static class SpringResourceMethodParameterBuilder
    extends ResourceBuilder.ResourceMethodParameterBuilder {
        final String defaultName;

        SpringResourceMethodParameterBuilder(ResourceBuilder.ResourceMethodBuilder method, MethodParameter param, String defaultName) {
            super(method, param);
            this.defaultName = defaultName;
        }

        protected void doFromAnnotations() {
            Parameter parameter = this.getParameter();
            Annotation[] annotations = parameter.getAnnotations();
            RequestParam requestParam = (RequestParam)FindAnnotation.findAnnotation((Annotation[])annotations, RequestParam.class);
            if (requestParam != null) {
                parameter.setParamType(Parameter.ParamType.QUERY_PARAM);
                parameter.setParamName(requestParam.name());
                if (parameter.getParamName().isEmpty() && !requestParam.value().isEmpty()) {
                    parameter.setParamName(requestParam.value());
                }
                if (!requestParam.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                    parameter.setDefaultValue(requestParam.defaultValue());
                }
                parameter.setEncoded(true);
            } else {
                RequestHeader header = (RequestHeader)FindAnnotation.findAnnotation((Annotation[])annotations, RequestHeader.class);
                if (header != null) {
                    parameter.setParamType(Parameter.ParamType.HEADER_PARAM);
                    parameter.setParamName(header.name());
                    if (parameter.getParamName().isEmpty() && !header.value().isEmpty()) {
                        parameter.setParamName(header.value());
                    }
                    if (!header.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                        parameter.setDefaultValue(header.defaultValue());
                    }
                } else {
                    CookieValue cookie = (CookieValue)FindAnnotation.findAnnotation((Annotation[])annotations, CookieValue.class);
                    if (cookie != null) {
                        parameter.setParamType(Parameter.ParamType.COOKIE_PARAM);
                        parameter.setParamName(cookie.name());
                        if (parameter.getParamName().isEmpty() && !cookie.value().isEmpty()) {
                            parameter.setParamName(cookie.value());
                        }
                        if (!cookie.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                            parameter.setDefaultValue(cookie.defaultValue());
                        }
                    } else {
                        PathVariable uriParam = (PathVariable)FindAnnotation.findAnnotation((Annotation[])annotations, PathVariable.class);
                        if (uriParam != null) {
                            parameter.setParamType(Parameter.ParamType.PATH_PARAM);
                            parameter.setParamName(uriParam.name());
                            if (parameter.getParamName().isEmpty() && !uriParam.value().isEmpty()) {
                                parameter.setParamName(uriParam.value());
                            }
                            parameter.setEncoded(true);
                        } else {
                            MatrixVariable matrix = (MatrixVariable)FindAnnotation.findAnnotation((Annotation[])annotations, MatrixVariable.class);
                            if (matrix != null) {
                                parameter.setParamType(Parameter.ParamType.MATRIX_PARAM);
                                parameter.setParamName(matrix.name());
                                if (parameter.getParamName().isEmpty() && !matrix.value().isEmpty()) {
                                    parameter.setParamName(matrix.value());
                                }
                                if (!matrix.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n")) {
                                    parameter.setDefaultValue(matrix.defaultValue());
                                }
                            } else if (FindAnnotation.findAnnotation((Annotation[])annotations, RequestBody.class) != null) {
                                parameter.setParamType(Parameter.ParamType.MESSAGE_BODY);
                            } else if (parameter.getType().getName().startsWith("javax.servlet.http")) {
                                parameter.setParamType(Parameter.ParamType.CONTEXT);
                            } else {
                                parameter.setParamType(Parameter.ParamType.UNKNOWN);
                            }
                        }
                    }
                }
            }
            if (parameter.getParamName().isEmpty() && this.defaultName != null) {
                parameter.setParamName(this.defaultName);
            }
        }
    }

    private static class SpringResourceMethodBuilder
    extends ResourceBuilder.ResourceMethodBuilder {
        SpringResourceMethodBuilder(ResourceBuilder.ResourceClassBuilder resourceClassBuilder, Method method, Method annotatedMethod) {
            super(resourceClassBuilder, method, annotatedMethod);
        }

        public ResourceBuilder.ResourceMethodParameterBuilder param(int i) {
            String defaultName = null;
            if (this.getMethod().getAnnotatedMethod().getParameters()[i].isNamePresent()) {
                defaultName = this.getMethod().getAnnotatedMethod().getParameters()[i].getName();
            }
            return new SpringResourceMethodParameterBuilder(this, this.getLocator().getParams()[i], defaultName);
        }
    }

    private static class SpringResourceClassBuilder
    extends ResourceBuilder.ResourceClassBuilder {
        SpringResourceClassBuilder(Class<?> root, String path) {
            super(root, path);
        }

        public ResourceBuilder.ResourceMethodBuilder method(Method method, Method annotatedMethod) {
            return new SpringResourceMethodBuilder(this, method, annotatedMethod);
        }
    }

    private static class RequestMappingData {
        private final String[] path;
        private final RequestMethod[] method;
        private final String[] params;
        private final String[] headers;
        private final String[] consumes;
        private final String[] produces;

        private RequestMappingData(String[] path, RequestMethod[] method, String[] params, String[] headers, String[] consumes, String[] produces) {
            this.path = path;
            this.method = method;
            this.params = params;
            this.headers = headers;
            this.consumes = consumes;
            this.produces = produces;
        }

        public String[] getPath() {
            return this.path;
        }

        public RequestMethod[] getMethod() {
            return this.method;
        }

        public String[] getParams() {
            return this.params;
        }

        public String[] getHeaders() {
            return this.headers;
        }

        public String[] getConsumes() {
            return this.consumes;
        }

        public String[] getProduces() {
            return this.produces;
        }

        public String getFirstPath() {
            if (this.path != null && this.path.length > 0) {
                return this.path[0];
            }
            return null;
        }

        public static RequestMappingData fromRequestMapping(RequestMapping requestMapping) {
            return new RequestMappingData(SpringResourceBuilder.getPath(requestMapping), requestMapping.method(), requestMapping.params(), requestMapping.headers(), requestMapping.consumes(), requestMapping.produces());
        }

        public static RequestMappingData fromAnnotation(Annotation annotation) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType.getAnnotation(RequestMapping.class) == null) {
                return null;
            }
            if (GetMapping.class.equals(annotationType)) {
                GetMapping mapping = (GetMapping)annotation;
                return new RequestMappingData(SpringResourceBuilder.getPath(mapping.path(), mapping.value()), new RequestMethod[]{RequestMethod.GET}, mapping.params(), mapping.headers(), mapping.consumes(), mapping.produces());
            }
            if (PostMapping.class.equals(annotationType)) {
                PostMapping mapping = (PostMapping)annotation;
                return new RequestMappingData(SpringResourceBuilder.getPath(mapping.path(), mapping.value()), new RequestMethod[]{RequestMethod.POST}, mapping.params(), mapping.headers(), mapping.consumes(), mapping.produces());
            }
            if (PutMapping.class.equals(annotationType)) {
                PutMapping mapping = (PutMapping)annotation;
                return new RequestMappingData(SpringResourceBuilder.getPath(mapping.path(), mapping.value()), new RequestMethod[]{RequestMethod.PUT}, mapping.params(), mapping.headers(), mapping.consumes(), mapping.produces());
            }
            if (DeleteMapping.class.equals(annotationType)) {
                DeleteMapping mapping = (DeleteMapping)annotation;
                return new RequestMappingData(SpringResourceBuilder.getPath(mapping.path(), mapping.value()), new RequestMethod[]{RequestMethod.DELETE}, mapping.params(), mapping.headers(), mapping.consumes(), mapping.produces());
            }
            if (PatchMapping.class.equals(annotationType)) {
                PatchMapping mapping = (PatchMapping)annotation;
                return new RequestMappingData(SpringResourceBuilder.getPath(mapping.path(), mapping.value()), new RequestMethod[]{RequestMethod.PATCH}, mapping.params(), mapping.headers(), mapping.consumes(), mapping.produces());
            }
            return null;
        }
    }
}

