/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.servlet;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.core.AsynchronousDispatcher;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.servlet.i18n.Messages;
import org.jboss.resteasy.spi.NotImplementedYetException;

@HandlesTypes(value={Application.class, Path.class, Provider.class})
public class ResteasyServletInitializer
implements ServletContainerInitializer {
    private static final String RESTEASY_MAPPING_PREFIX = "resteasy.servlet.mapping.prefix";
    private static final String APPLICATION = "jakarta.ws.rs.Application";
    static final Set<String> ignoredPackages = new HashSet<String>();

    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        if (classes == null || classes.size() == 0) {
            return;
        }
        HashSet appClasses = new HashSet();
        HashSet providers = new HashSet();
        HashSet resources = new HashSet();
        for (Class<?> clazz : classes) {
            if (clazz.isInterface() || ignoredPackages.contains(clazz.getPackage().getName())) continue;
            if (clazz.isAnnotationPresent(Path.class)) {
                resources.add(clazz);
                continue;
            }
            if (clazz.isAnnotationPresent(Provider.class)) {
                providers.add(clazz);
                continue;
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            appClasses.add(clazz);
        }
        if (appClasses.size() == 0 && resources.size() == 0) {
            return;
        }
        if (appClasses.size() == 0) {
            return;
        }
        for (Class<Object> clazz : appClasses) {
            this.register(clazz, providers, resources, servletContext);
        }
    }

    protected void handleNoApplicationClass(Set<Class<?>> providers, Set<Class<?>> resources, ServletContext servletContext) {
        ServletRegistration defaultApp = null;
        for (ServletRegistration reg : servletContext.getServletRegistrations().values()) {
            if (!reg.getName().equals(Application.class.getName())) continue;
            defaultApp = reg;
        }
        if (defaultApp == null) {
            return;
        }
        throw new NotImplementedYetException(Messages.MESSAGES.defaultApplicationNotImplemented());
    }

    private Set<ServletRegistration> getServletsForApplication(Class<?> applicationClass, ServletContext servletContext) {
        HashSet<ServletRegistration> set = new HashSet<ServletRegistration>();
        ServletRegistration reg = servletContext.getServletRegistration(applicationClass.getName());
        if (reg != null && reg.getMappings().size() == 1) {
            set.add(reg);
        }
        for (ServletRegistration sr : servletContext.getServletRegistrations().values()) {
            String appClassName = sr.getInitParameter(APPLICATION);
            if (!applicationClass.getName().equals(appClassName) || sr.getMappings().size() != 1) continue;
            set.add(sr);
        }
        return set;
    }

    protected void register(Class<?> applicationClass, Set<Class<?>> providers, Set<Class<?>> resources, ServletContext servletContext) {
        String prefix;
        Set<ServletRegistration> servletsForApp = this.getServletsForApplication(applicationClass, servletContext);
        if (!servletsForApp.isEmpty()) {
            for (ServletRegistration servletReg : servletsForApp) {
                String prefix2;
                String servletClassName = servletReg.getClassName();
                if (servletClassName == null) {
                    servletContext.addServlet(servletReg.getName(), HttpServlet30Dispatcher.class);
                }
                if ((prefix2 = (String)servletReg.getMappings().iterator().next()).endsWith("*")) {
                    prefix2 = prefix2.substring(0, prefix2.length() - 1);
                }
                if (prefix2.length() > 1 && prefix2.endsWith("/")) {
                    prefix2 = prefix2.substring(0, prefix2.length() - 1);
                }
                this.registerResourcesAndProviders(servletReg, providers, resources, applicationClass, prefix2);
            }
            return;
        }
        ApplicationPath path = applicationClass.getAnnotation(ApplicationPath.class);
        if (path == null) {
            return;
        }
        Object mapping = path.value();
        if (!((String)mapping).startsWith("/")) {
            mapping = "/" + (String)mapping;
        }
        if (!(prefix = mapping).equals("/") && prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!((String)mapping).endsWith("/*")) {
            mapping = ((String)mapping).endsWith("/") ? (String)mapping + "*" : (String)mapping + "/*";
        }
        ServletRegistration.Dynamic reg = servletContext.addServlet(applicationClass.getName(), HttpServlet30Dispatcher.class);
        reg.setLoadOnStartup(1);
        reg.setAsyncSupported(true);
        reg.addMapping(new String[]{mapping});
        this.registerResourcesAndProviders((ServletRegistration)reg, providers, resources, applicationClass, prefix);
    }

    private void registerResourcesAndProviders(ServletRegistration reg, Set<Class<?>> providers, Set<Class<?>> resources, Class<?> appClass, String prefix) {
        boolean first;
        StringBuilder builder;
        reg.setInitParameter(APPLICATION, appClass.getName());
        reg.setInitParameter(RESTEASY_MAPPING_PREFIX, prefix);
        if (resources.size() > 0) {
            builder = new StringBuilder();
            first = true;
            for (Class<?> resource : resources) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(resource.getName());
            }
            reg.setInitParameter("resteasy.scanned.resources", builder.toString());
        }
        if (providers.size() > 0) {
            builder = new StringBuilder();
            first = true;
            for (Class<?> provider : providers) {
                if (first) {
                    first = false;
                } else {
                    builder.append(",");
                }
                builder.append(provider.getName());
            }
            reg.setInitParameter("resteasy.scanned.providers", builder.toString());
        }
    }

    static {
        ignoredPackages.add(AsynchronousDispatcher.class.getPackage().getName());
    }
}

