/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.rxjava2.propagation;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.BiFunction;
import java.util.concurrent.Executor;
import org.jboss.resteasy.concurrent.ContextualExecutors;

class ContextPropagatorOnSingleCreateAction
implements BiFunction<Single, SingleObserver, SingleObserver> {
    ContextPropagatorOnSingleCreateAction() {
    }

    public SingleObserver apply(Single s, SingleObserver o) throws Exception {
        return new ContextCapturerSingle(s, o, ContextualExecutors.executor());
    }

    private static class ContextCapturerSingle<T>
    implements SingleObserver<T> {
        private final SingleObserver<T> source;
        private final Executor contextExecutor;

        private ContextCapturerSingle(Single<T> s, SingleObserver<T> o, Executor contextExecutor) {
            this.source = o;
            this.contextExecutor = contextExecutor;
        }

        public void onError(Throwable t) {
            this.contextExecutor.execute(() -> this.source.onError(t));
        }

        public void onSubscribe(Disposable d) {
            this.contextExecutor.execute(() -> this.source.onSubscribe(d));
        }

        public void onSuccess(T v) {
            this.contextExecutor.execute(() -> this.source.onSuccess(v));
        }
    }
}

