/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactor;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.sse.SseEventSource;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.plugins.providers.sse.InboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.client.SseEventSourceImpl;
import org.jboss.resteasy.reactor.FluxRxInvoker;
import org.jboss.resteasy.reactor.i18n.Messages;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class FluxRxInvokerImpl
implements FluxRxInvoker {
    private static Object monitor = new Object();
    private ClientInvocationBuilder syncInvoker;
    private ScheduledExecutorService executorService;
    private FluxSink.OverflowStrategy overflowStrategy = FluxSink.OverflowStrategy.BUFFER;

    public FluxRxInvokerImpl(SyncInvoker syncInvoker, ExecutorService executorService) {
        if (!(syncInvoker instanceof ClientInvocationBuilder)) {
            throw new ProcessingException(Messages.MESSAGES.expectedClientInvocationBuilder(syncInvoker.getClass().getName()));
        }
        this.syncInvoker = (ClientInvocationBuilder)syncInvoker;
        if (executorService instanceof ScheduledExecutorService) {
            this.executorService = (ScheduledExecutorService)executorService;
        }
    }

    public Flux<?> get() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "GET", null, this.getAccept());
    }

    public <R> Flux<?> get(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public <R> Flux<?> get(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "GET", null, this.getAccept());
    }

    public Flux<?> put(Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "PUT", entity, this.getAccept());
    }

    public <R> Flux<?> put(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public <R> Flux<?> put(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "PUT", entity, this.getAccept());
    }

    public Flux<?> post(Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "POST", entity, this.getAccept());
    }

    public <R> Flux<?> post(Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public <R> Flux<?> post(Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "POST", entity, this.getAccept());
    }

    public Flux<?> delete() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "DELETE", null, this.getAccept());
    }

    public <R> Flux<?> delete(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public <R> Flux<?> delete(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "DELETE", null, this.getAccept());
    }

    public Flux<?> head() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "HEAD", null, this.getAccept());
    }

    public Flux<?> options() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "OPTIONS", null, this.getAccept());
    }

    public <R> Flux<?> options(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public <R> Flux<?> options(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "OPTIONS", null, this.getAccept());
    }

    public Flux<?> trace() {
        return this.eventSourceToObservable(this.getEventSource(), String.class, "TRACE", null, this.getAccept());
    }

    public <R> Flux<?> trace(Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public <R> Flux<?> trace(GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, "TRACE", null, this.getAccept());
    }

    public Flux<?> method(String name) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, name, null, this.getAccept());
    }

    public <R> Flux<?> method(String name, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public <R> Flux<?> method(String name, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, null, this.getAccept());
    }

    public Flux<?> method(String name, Entity<?> entity) {
        return this.eventSourceToObservable(this.getEventSource(), String.class, name, entity, this.getAccept());
    }

    public <R> Flux<?> method(String name, Entity<?> entity, Class<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    public <R> Flux<?> method(String name, Entity<?> entity, GenericType<R> responseType) {
        return this.eventSourceToObservable(this.getEventSource(), responseType, name, entity, this.getAccept());
    }

    @Override
    public FluxSink.OverflowStrategy getOverflowStrategy() {
        return this.overflowStrategy;
    }

    @Override
    public void setOverflowStrategy(FluxSink.OverflowStrategy overflowStrategy) {
        this.overflowStrategy = overflowStrategy;
    }

    private <T> Flux<T> eventSourceToObservable(SseEventSourceImpl sseEventSource, Class<T> clazz, String verb, Entity<?> entity, MediaType[] mediaTypes) {
        return this.eventSourceToFlux(sseEventSource, e -> e.readData(clazz, e.getMediaType()), verb, entity, mediaTypes);
    }

    private <T> Flux<T> eventSourceToObservable(SseEventSourceImpl sseEventSource, GenericType<T> type, String verb, Entity<?> entity, MediaType[] mediaTypes) {
        return this.eventSourceToFlux(sseEventSource, e -> e.readData(type, e.getMediaType()), verb, entity, mediaTypes);
    }

    private <T> Flux<T> eventSourceToFlux(SseEventSourceImpl sseEventSource, Function<InboundSseEventImpl, T> tSupplier, String verb, Entity<?> entity, MediaType[] mediaTypes) {
        Flux flux = Flux.create(emitter -> {
            sseEventSource.register(e -> emitter.next(tSupplier.apply((InboundSseEventImpl)e)), t -> emitter.error(t), () -> emitter.complete());
            Object object = monitor;
            synchronized (object) {
                if (!sseEventSource.isOpen()) {
                    sseEventSource.open(null, verb, entity, mediaTypes);
                }
            }
        }, (FluxSink.OverflowStrategy)this.overflowStrategy);
        return flux;
    }

    private SseEventSourceImpl getEventSource() {
        SseEventSourceImpl.SourceBuilder builder = (SseEventSourceImpl.SourceBuilder)SseEventSource.target((WebTarget)this.syncInvoker.getTarget());
        if (this.executorService != null) {
            builder.executor(this.executorService);
        }
        SseEventSourceImpl sseEventSource = (SseEventSourceImpl)builder.build();
        sseEventSource.setAlwaysReconnect(false);
        return sseEventSource;
    }

    private MediaType[] getAccept() {
        if (this.syncInvoker instanceof ClientInvocationBuilder) {
            ClientInvocationBuilder builder = this.syncInvoker;
            List accept = builder.getHeaders().getAcceptableMediaTypes();
            return accept.toArray(new MediaType[accept.size()]);
        }
        return null;
    }
}

