/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.util.Set;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthRequestToken;
import org.jboss.resteasy.auth.oauth.OAuthToken;

public class OAuthProviderChecker
implements OAuthProvider {
    private OAuthProvider provider;

    public OAuthProviderChecker(OAuthProvider provider) {
        this.provider = provider;
    }

    private <T> T checkNull(T arg) {
        if (arg == null) {
            throw new RuntimeException("OAuthProvider should not return null");
        }
        return arg;
    }

    @Override
    public OAuthConsumer registerConsumer(String consumerKey, String displayName, String connectURI) throws OAuthException {
        return this.checkNull(this.provider.registerConsumer(consumerKey, displayName, connectURI));
    }

    @Override
    public OAuthConsumer getConsumer(String consumerKey) throws OAuthException {
        return this.checkNull(this.provider.getConsumer(consumerKey));
    }

    @Override
    public String getRealm() {
        return this.checkNull(this.provider.getRealm());
    }

    @Override
    public OAuthRequestToken getRequestToken(String consumerKey, String requestKey) throws OAuthException {
        return this.checkNull(this.provider.getRequestToken(consumerKey, requestKey));
    }

    @Override
    public OAuthToken getAccessToken(String consumerKey, String accessKey) throws OAuthException {
        return this.checkNull(this.provider.getAccessToken(consumerKey, accessKey));
    }

    @Override
    public void checkTimestamp(OAuthToken token, long timestamp) throws OAuthException {
        this.provider.checkTimestamp(token, timestamp);
    }

    @Override
    public OAuthToken makeAccessToken(String consumerKey, String requestKey, String verifier) throws OAuthException {
        return this.checkNull(this.provider.makeAccessToken(consumerKey, requestKey, verifier));
    }

    @Override
    public OAuthToken makeRequestToken(String consumerKey, String callback, String[] scopes, String[] permissions) throws OAuthException {
        return this.checkNull(this.provider.makeRequestToken(consumerKey, callback, scopes, permissions));
    }

    @Override
    public String authoriseRequestToken(String consumerKey, String requestKey) throws OAuthException {
        return this.checkNull(this.provider.authoriseRequestToken(consumerKey, requestKey));
    }

    @Override
    public void registerConsumerScopes(String consumerKey, String[] scopes) throws OAuthException {
        this.provider.registerConsumerScopes(consumerKey, scopes);
    }

    @Override
    public void registerConsumerPermissions(String consumerKey, String[] permissions) throws OAuthException {
        this.provider.registerConsumerPermissions(consumerKey, permissions);
    }

    @Override
    public Set<String> convertPermissionsToRoles(String[] permissions) {
        return this.provider.convertPermissionsToRoles(permissions);
    }
}

