/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.jboss.resteasy.auth.oauth.OAuthConsumer;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthToken;
import org.jboss.resteasy.auth.oauth.OAuthUtils;
import org.jboss.resteasy.auth.oauth.OAuthValidator;
import org.jboss.resteasy.logging.Logger;

public class OAuthFilter
implements Filter {
    public static final String OAUTH_AUTH_METHOD = "OAuth";
    private static final Logger logger = Logger.getLogger(OAuthFilter.class);
    private OAuthProvider provider;
    private OAuthValidator validator;

    public void init(FilterConfig config) throws ServletException {
        logger.info("Loading OAuth Filter");
        ServletContext context = config.getServletContext();
        this.provider = OAuthUtils.getOAuthProvider(context);
        this.validator = OAuthUtils.getValidator(context, this.provider);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this._doFilter((HttpServletRequest)request, (HttpServletResponse)response, filterChain);
    }

    protected void _doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        logger.debug("Filtering " + request.getMethod() + " " + request.getRequestURL().toString());
        OAuthMessage message = OAuthUtils.readMessage(request);
        try {
            message.requireParameters(new String[]{"oauth_consumer_key", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce"});
            String consumerKey = message.getParameter("oauth_consumer_key");
            OAuthConsumer consumer = this.provider.getConsumer(consumerKey);
            OAuthToken accessToken = null;
            String accessTokenString = message.getParameter("oauth_token");
            if (accessTokenString != null) {
                accessToken = this.provider.getAccessToken(consumer.getKey(), accessTokenString);
                OAuthUtils.validateRequestWithAccessToken(request, message, accessToken, this.validator, consumer);
            } else {
                OAuthUtils.validateRequestWithoutAccessToken(request, message, this.validator, consumer);
            }
            request = this.createSecurityContext(request, consumer, accessToken);
            logger.debug("doFilter");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (OAuthException x) {
            OAuthUtils.makeErrorResponse(response, x.getMessage(), x.getHttpCode(), this.provider);
        }
        catch (OAuthProblemException x) {
            OAuthUtils.makeErrorResponse(response, x.getProblem(), OAuthUtils.getHttpCode(x), this.provider);
        }
        catch (Exception x) {
            OAuthUtils.makeErrorResponse(response, x.getMessage(), 500, this.provider);
        }
    }

    protected OAuthProvider getProvider() {
        return this.provider;
    }

    protected HttpServletRequest createSecurityContext(HttpServletRequest request, OAuthConsumer consumer, OAuthToken accessToken) {
        return request;
    }
}

