/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.io.IOException;
import java.net.URISyntaxException;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.SimpleOAuthValidator;
import org.jboss.resteasy.auth.oauth.OAuthException;
import org.jboss.resteasy.auth.oauth.OAuthProvider;
import org.jboss.resteasy.auth.oauth.OAuthToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthValidator
extends SimpleOAuthValidator {
    private static final Logger logger = LoggerFactory.getLogger(OAuthValidator.class);
    private OAuthProvider provider;

    public OAuthValidator(OAuthProvider provider) {
        this.provider = provider;
    }

    @Deprecated
    public void validateMessage(OAuthMessage message, OAuthAccessor accessor) throws net.oauth.OAuthException, IOException, URISyntaxException {
        throw new RuntimeException("Do not use this method");
    }

    public void validateMessage(OAuthMessage message, OAuthAccessor accessor, OAuthToken requestToken) throws net.oauth.OAuthException, IOException, URISyntaxException {
        this.checkSingleParameters(message);
        this.validateVersion(message);
        this.validateSignature(message, accessor);
        this.validateTimestampAndNonce(message, requestToken);
    }

    protected void validateTimestampAndNonce(OAuthMessage message, OAuthToken token) throws IOException, OAuthProblemException {
        message.requireParameters(new String[]{"oauth_timestamp", "oauth_nonce"});
        long timestamp = Long.parseLong(message.getParameter("oauth_timestamp"));
        long now = this.currentTimeMsec();
        this.validateTimestamp(message, now, token);
        this.validateNonce(message, timestamp, now);
    }

    protected void validateTimestamp(OAuthMessage message, long timestamp, OAuthToken token) throws IOException, OAuthProblemException {
        if (token == null) {
            return;
        }
        try {
            this.provider.checkTimestamp(token, timestamp);
        }
        catch (OAuthException e) {
            logger.error("Invalid timestamp", (Throwable)e);
            throw new OAuthProblemException("timestamp_refused");
        }
    }
}

