/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.auth.oauth;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.resteasy.auth.oauth.OAuthPermissions;

public class OAuthConsumer {
    private String key;
    private String secret;
    private String displayName;
    private String connectURI;
    private Set<String> scopes;
    private OAuthPermissions permissions;

    public OAuthConsumer(String key, String secret, String displayName, String connectURI) {
        this.key = key;
        this.secret = secret;
        this.displayName = displayName;
        this.connectURI = connectURI;
    }

    public OAuthConsumer(String key, String secret, String displayName, String connectURI, OAuthPermissions perms) {
        this.key = key;
        this.secret = secret;
        this.displayName = displayName;
        this.connectURI = connectURI;
        this.permissions = perms;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getConnectURI() {
        return this.connectURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getScopes() {
        OAuthConsumer oAuthConsumer = this;
        synchronized (oAuthConsumer) {
            return this.scopes != null ? this.scopes.toArray(new String[0]) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScopes(String[] scopes) {
        OAuthConsumer oAuthConsumer = this;
        synchronized (oAuthConsumer) {
            this.scopes = new HashSet<String>(Arrays.asList(scopes));
        }
    }

    public OAuthPermissions getPermissions() {
        return this.permissions;
    }
}

