/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class MultiPromise {
    private final ChannelHandlerContext ctx;
    private final AtomicInteger created = new AtomicInteger();
    private final AtomicReference<Throwable> cause = new AtomicReference();
    private final ChannelPromise promise;
    private boolean started;

    public MultiPromise(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.ctx = ctx;
        this.promise = promise;
    }

    public ChannelPromise newPromise() {
        this.created.getAndIncrement();
        return this.ctx.newPromise().addListener(f -> {
            if (!f.isSuccess()) {
                this.cause.compareAndSet(null, f.cause());
            }
            if (this.created.decrementAndGet() == 0) {
                this.forward();
            }
        });
    }

    private synchronized void forward() {
        if (!this.started) {
            return;
        }
        if (!this.promise.isDone()) {
            Throwable throwable = this.cause.get();
            if (throwable != null) {
                this.promise.setFailure(throwable);
            } else {
                this.promise.setSuccess();
            }
        }
    }

    public synchronized void readyToForward() {
        this.started = true;
        if (this.created.get() == 0) {
            this.forward();
        }
    }
}

