/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import java.util.List;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.NettyUtil;
import org.jboss.resteasy.plugins.server.netty.i18n.LogMessages;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;

@Deprecated(forRemoval=true, since="6.2.13.Final")
@ChannelHandler.Sharable
public class RestEasyHttpRequestDecoder
extends MessageToMessageDecoder<HttpRequest> {
    private final SynchronousDispatcher dispatcher;
    private final String servletMappingPrefix;
    private final String proto;

    @Deprecated
    public RestEasyHttpRequestDecoder(SynchronousDispatcher dispatcher, String servletMappingPrefix, Protocol protocol) {
        this(dispatcher, servletMappingPrefix, protocol == Protocol.HTTP ? "http" : "https");
    }

    public RestEasyHttpRequestDecoder(SynchronousDispatcher dispatcher, String servletMappingPrefix, String protocol) {
        this.dispatcher = dispatcher;
        this.servletMappingPrefix = servletMappingPrefix;
        this.proto = protocol;
    }

    protected void decode(ChannelHandlerContext ctx, HttpRequest request, List<Object> out) throws Exception {
        DecoderResult decoderResult = request.decoderResult();
        if (decoderResult.isFailure()) {
            NettyHttpResponse response = new NettyHttpResponse(ctx, false, this.dispatcher.getProviderFactory(), request.method());
            Throwable t = decoderResult.cause();
            if (t != null && t.getLocalizedMessage() != null) {
                response.sendError(400, t.getLocalizedMessage());
            } else {
                response.sendError(400);
            }
            ctx.close();
            return;
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        NettyHttpResponse response = new NettyHttpResponse(ctx, keepAlive, this.dispatcher.getProviderFactory(), request.method());
        try {
            ResteasyHttpHeaders headers = NettyUtil.extractHttpHeaders(request);
            ResteasyUriInfo uriInfo = NettyUtil.extractUriInfo(request, this.servletMappingPrefix, this.proto);
            NettyHttpRequest nettyRequest = new NettyHttpRequest(ctx, headers, uriInfo, request.method().name(), this.dispatcher, response, HttpUtil.is100ContinueExpected((HttpMessage)request));
            if (request instanceof HttpContent) {
                HttpContent content = (HttpContent)request;
                ByteBuf byteBuf = content.content();
                if (byteBuf.readableBytes() > 0) {
                    ByteBuf buf = byteBuf.retain();
                    nettyRequest.setContentBuffer(buf);
                }
                out.add((Object)nettyRequest);
            }
        }
        catch (Exception e) {
            response.sendError(400);
            LogMessages.LOGGER.warn(Messages.MESSAGES.failedToParseRequest(), e);
        }
    }

    @Deprecated
    public static enum Protocol {
        HTTPS,
        HTTP;

    }
}

