/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.i18n.LogMessages;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;

@Deprecated(forRemoval=true, since="6.2.13.Final")
@ChannelHandler.Sharable
public class RequestHandler
extends SimpleChannelInboundHandler {
    protected final RequestDispatcher dispatcher;

    public RequestHandler(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof NettyHttpRequest) {
            NettyHttpRequest request = (NettyHttpRequest)((Object)msg);
            try {
                NettyHttpResponse response = request.getResponse();
                try {
                    this.dispatcher.service(ctx, (HttpRequest)request, response, true);
                }
                catch (Failure e1) {
                    response.reset();
                    response.setStatus(e1.getErrorCode());
                }
                catch (Exception ex) {
                    response.reset();
                    response.setStatus(500);
                    LogMessages.LOGGER.error(Messages.MESSAGES.unexpected(), ex);
                }
                if (!request.getAsyncContext().isSuspended()) {
                    response.finish();
                }
            }
            finally {
                request.releaseContentBuffer();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            LogMessages.LOGGER.info(Messages.MESSAGES.exceptionCaught(), e);
            ctx.close();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.close();
        }
    }
}

