/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.plugins.server.netty.MultiPromise;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.spi.AsyncOutputStream;

@Deprecated(forRemoval=true, since="6.2.13.Final")
public class ChunkOutputStream
extends AsyncOutputStream {
    private final Object writeLock = new Object();
    private final ByteBuf buffer;
    private final ChannelHandlerContext ctx;
    private final NettyHttpResponse response;

    ChunkOutputStream(NettyHttpResponse response, ChannelHandlerContext ctx, int chunksize) {
        this.response = response;
        if (chunksize < 1) {
            throw new IllegalArgumentException(Messages.MESSAGES.chunkSizeMustBeAtLeastOne());
        }
        this.buffer = Unpooled.buffer((int)0, (int)chunksize);
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (this.buffer.maxWritableBytes() < 1) {
                this.flush();
            }
            this.buffer.writeByte(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.response.isCommitted()) {
            throw new IllegalStateException(Messages.MESSAGES.responseIsCommitted());
        }
        Object object = this.writeLock;
        synchronized (object) {
            this.buffer.clear();
        }
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.write(b, off, len, this.ctx.newPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(byte[] b, int off, int len, ChannelPromise promise) throws IOException {
        int dataToWriteOffset = off;
        MultiPromise mp = new MultiPromise(this.ctx, promise);
        Object object = this.writeLock;
        synchronized (object) {
            int dataLengthLeftToWrite;
            int spaceLeftInCurrentChunk;
            for (dataLengthLeftToWrite = len; (spaceLeftInCurrentChunk = this.buffer.maxWritableBytes()) < dataLengthLeftToWrite; dataLengthLeftToWrite -= spaceLeftInCurrentChunk) {
                this.buffer.writeBytes(b, dataToWriteOffset, spaceLeftInCurrentChunk);
                dataToWriteOffset += spaceLeftInCurrentChunk;
                this.flush(mp.newPromise());
            }
            if (dataLengthLeftToWrite > 0) {
                this.buffer.writeBytes(b, dataToWriteOffset, dataLengthLeftToWrite);
                this.flush(mp.newPromise());
            }
        }
        mp.readyToForward();
    }

    public void flush() throws IOException {
        this.flush(this.ctx.newPromise());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ChannelPromise promise) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int readable = this.buffer.readableBytes();
            if (readable == 0) {
                promise.setSuccess();
                return;
            }
            if (!this.response.isCommitted()) {
                this.response.prepareChunkStream();
            }
            this.ctx.writeAndFlush((Object)new DefaultHttpContent(this.buffer.copy()), promise);
            this.buffer.clear();
        }
        super.flush();
    }

    public CompletionStage<Void> asyncFlush() {
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        try {
            ChannelPromise promise = this.ctx.newPromise();
            promise.addListener(v -> {
                if (v.isSuccess()) {
                    ret.complete(null);
                } else {
                    ret.completeExceptionally(v.cause());
                }
            });
            this.flush(promise);
        }
        catch (IOException e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }

    public CompletionStage<Void> asyncWrite(byte[] bytes, int offset, int length) {
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        try {
            ChannelPromise promise = this.ctx.newPromise();
            promise.addListener(v -> {
                if (v.isSuccess()) {
                    ret.complete(null);
                } else {
                    ret.completeExceptionally(v.cause());
                }
            });
            this.write(bytes, offset, length, promise);
        }
        catch (IOException e) {
            ret.completeExceptionally(e);
        }
        return ret;
    }
}

