/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.spi.UnhandledException;

public class NettyHttpRequest
extends BaseHttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected SynchronousDispatcher dispatcher;
    protected String httpMethod;
    protected InputStream inputStream;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected NettyHttpResponse response;
    private final boolean is100ContinueExpected;
    private NettyExecutionContext executionContext;
    private final ChannelHandlerContext ctx;
    private volatile boolean flushed;
    private ByteBuf content;

    public NettyHttpRequest(ChannelHandlerContext ctx, ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uri, String httpMethod, SynchronousDispatcher dispatcher, NettyHttpResponse response, boolean is100ContinueExpected) {
        super(uri);
        this.is100ContinueExpected = is100ContinueExpected;
        this.response = response;
        this.dispatcher = dispatcher;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.executionContext = new NettyExecutionContext(this, response, dispatcher);
        this.ctx = ctx;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = NettyHttpRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return this.executionContext;
    }

    public boolean isFlushed() {
        return this.flushed;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public NettyHttpResponse getResponse() {
        return this.response;
    }

    public boolean isKeepAlive() {
        return this.response.isKeepAlive();
    }

    public boolean is100ContinueExpected() {
        return this.is100ContinueExpected;
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }

    public void setContentBuffer(ByteBuf content) {
        this.content = content;
        this.inputStream = new ByteBufInputStream(content);
    }

    public void releaseContentBuffer() {
        if (this.content != null) {
            this.content.release();
        }
    }

    class NettyExecutionContext
    extends AbstractExecutionContext {
        protected final NettyHttpRequest request;
        protected final NettyHttpResponse response;
        protected volatile boolean done;
        protected volatile boolean cancelled;
        protected volatile boolean wasSuspended;
        protected NettyHttpAsyncResponse asyncResponse;

        public NettyExecutionContext(NettyHttpRequest request, NettyHttpResponse response, SynchronousDispatcher dispatcher) {
            super(dispatcher, (HttpRequest)request, (HttpResponse)response);
            this.request = request;
            this.response = response;
            this.asyncResponse = new NettyHttpAsyncResponse(dispatcher, request, response);
        }

        public boolean isSuspended() {
            return this.wasSuspended;
        }

        public ResteasyAsynchronousResponse getAsyncResponse() {
            return this.asyncResponse;
        }

        public ResteasyAsynchronousResponse suspend() throws IllegalStateException {
            return this.suspend(-1L);
        }

        public ResteasyAsynchronousResponse suspend(long millis) throws IllegalStateException {
            return this.suspend(millis, TimeUnit.MILLISECONDS);
        }

        public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) throws IllegalStateException {
            if (this.wasSuspended) {
                throw new IllegalStateException(Messages.MESSAGES.alreadySuspended());
            }
            this.wasSuspended = true;
            return this.asyncResponse;
        }

        class NettyHttpAsyncResponse
        extends AbstractAsynchronousResponse {
            private final Object responseLock;
            protected ScheduledFuture timeoutFuture;
            private NettyHttpResponse nettyResponse;

            public NettyHttpAsyncResponse(SynchronousDispatcher dispatcher, NettyHttpRequest request, NettyHttpResponse response) {
                super(dispatcher, (HttpRequest)request, (HttpResponse)response);
                this.responseLock = new Object();
                this.nettyResponse = response;
            }

            public void initialRequestThreadFinished() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done) {
                        return;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return;
                    }
                    NettyExecutionContext.this.done = true;
                    this.nettyFlush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Object entity) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    return this.internalResume(entity, t -> this.nettyFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean resume(Throwable ex) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    if (NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    return this.internalResume(ex, t -> {
                        if (t instanceof UnhandledException) {
                            this.internalResume(Response.status((int)500).build(), t2 -> this.nettyFlush());
                        } else {
                            this.nettyFlush();
                        }
                    });
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel() {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build(), t -> this.nettyFlush());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(int retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), t -> this.nettyFlush());
                }
            }

            protected synchronized void nettyFlush() {
                NettyHttpRequest.this.flushed = true;
                try {
                    this.nettyResponse.finish();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean cancel(Date retryAfter) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.cancelled) {
                        return true;
                    }
                    if (NettyExecutionContext.this.done) {
                        return false;
                    }
                    NettyExecutionContext.this.done = true;
                    NettyExecutionContext.this.cancelled = true;
                    return this.internalResume(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).header("Retry-After", (Object)retryAfter).build(), t -> this.nettyFlush());
                }
            }

            public boolean isSuspended() {
                return !NettyExecutionContext.this.done && !NettyExecutionContext.this.cancelled;
            }

            public boolean isCancelled() {
                return NettyExecutionContext.this.cancelled;
            }

            public boolean isDone() {
                return NettyExecutionContext.this.done;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean setTimeout(long time, TimeUnit unit) {
                Object object = this.responseLock;
                synchronized (object) {
                    if (NettyExecutionContext.this.done || NettyExecutionContext.this.cancelled) {
                        return false;
                    }
                    if (this.timeoutFuture != null && !this.timeoutFuture.cancel(false)) {
                        return false;
                    }
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            NettyHttpAsyncResponse.this.handleTimeout();
                        }
                    };
                    this.timeoutFuture = NettyHttpRequest.this.ctx.executor().schedule(task, time, unit);
                }
                return true;
            }

            protected void handleTimeout() {
                if (this.timeoutHandler != null) {
                    this.timeoutHandler.handleTimeout((AsyncResponse)this);
                }
                if (NettyExecutionContext.this.done) {
                    return;
                }
                this.resume((Throwable)new ServiceUnavailableException());
            }
        }
    }
}

