/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.plugins.server.netty.RequestHandler;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpRequestDecoder;
import org.jboss.resteasy.plugins.server.netty.RestEasyHttpResponseEncoder;
import org.jboss.resteasy.plugins.server.netty.SniConfiguration;
import org.jboss.resteasy.spi.ResteasyDeployment;

public class NettyJaxrsServer
implements EmbeddedJaxrsServer {
    protected ServerBootstrap bootstrap = new ServerBootstrap();
    protected String hostname = null;
    protected int configuredPort = 8080;
    protected int runtimePort = -1;
    protected ResteasyDeployment deployment = new ResteasyDeployment();
    protected String root = "";
    protected SecurityDomain domain;
    private EventLoopGroup eventLoopGroup;
    private EventLoopGroup eventExecutor;
    private int ioWorkerCount = Runtime.getRuntime().availableProcessors() * 2;
    private int executorThreadCount = 16;
    private SSLContext sslContext;
    private SniConfiguration sniConfiguration;
    private int maxRequestSize = 0xA00000;
    private int maxInitialLineLength = 4096;
    private int maxHeaderSize = 8192;
    private int maxChunkSize = 8192;
    private int backlog = 128;
    private int idleTimeout = -1;
    private List<ChannelHandler> channelHandlers = Collections.emptyList();
    private Map<ChannelOption, Object> channelOptions = Collections.emptyMap();
    private Map<ChannelOption, Object> childChannelOptions = Collections.emptyMap();
    private List<ChannelHandler> httpChannelHandlers = Collections.emptyList();

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setSniConfiguration(SniConfiguration sniConfiguration) {
        this.sniConfiguration = sniConfiguration;
    }

    public SniConfiguration getSniConfiguration() {
        return this.sniConfiguration;
    }

    public void setIoWorkerCount(int ioWorkerCount) {
        this.ioWorkerCount = ioWorkerCount;
    }

    public void setExecutorThreadCount(int executorThreadCount) {
        this.executorThreadCount = executorThreadCount;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setMaxInitialLineLength(int maxInitialLineLength) {
        this.maxInitialLineLength = maxInitialLineLength;
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.runtimePort > 0 ? this.runtimePort : this.configuredPort;
    }

    public void setPort(int port) {
        this.configuredPort = port;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeoutSeconds) {
        this.idleTimeout = idleTimeoutSeconds;
    }

    public void setChannelHandlers(List<ChannelHandler> channelHandlers) {
        this.channelHandlers = channelHandlers == null ? Collections.emptyList() : channelHandlers;
    }

    public void setHttpChannelHandlers(List<ChannelHandler> httpChannelHandlers) {
        this.httpChannelHandlers = httpChannelHandlers == null ? Collections.emptyList() : httpChannelHandlers;
    }

    public void setChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.channelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
    }

    public void setChildChannelOptions(Map<ChannelOption, Object> channelOptions) {
        this.childChannelOptions = channelOptions == null ? Collections.emptyMap() : channelOptions;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public void setRootResourcePath(String rootResourcePath) {
        this.root = rootResourcePath;
        if (this.root != null && this.root.equals("/")) {
            this.root = "";
        }
    }

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setSecurityDomain(SecurityDomain sc) {
        this.domain = sc;
    }

    protected RequestDispatcher createRequestDispatcher() {
        return new RequestDispatcher((SynchronousDispatcher)this.deployment.getDispatcher(), this.deployment.getProviderFactory(), this.domain);
    }

    public void start() {
        this.eventLoopGroup = new NioEventLoopGroup(this.ioWorkerCount);
        this.eventExecutor = new NioEventLoopGroup(this.executorThreadCount);
        this.deployment.start();
        ((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler(this.createChannelInitializer()).option(ChannelOption.SO_BACKLOG, (Object)this.backlog)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        for (Map.Entry<ChannelOption, Object> entry : this.channelOptions.entrySet()) {
            this.bootstrap.option(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ChannelOption, Object> entry : this.childChannelOptions.entrySet()) {
            this.bootstrap.childOption(entry.getKey(), entry.getValue());
        }
        InetSocketAddress socketAddress = null == this.hostname || this.hostname.isEmpty() ? new InetSocketAddress(this.configuredPort) : new InetSocketAddress(this.hostname, this.configuredPort);
        Channel channel = this.bootstrap.bind((SocketAddress)socketAddress).syncUninterruptibly().channel();
        this.runtimePort = ((InetSocketAddress)channel.localAddress()).getPort();
    }

    private ChannelInitializer<SocketChannel> createChannelInitializer() {
        final RequestDispatcher dispatcher = this.createRequestDispatcher();
        if (this.sslContext == null && this.sniConfiguration == null) {
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    NettyJaxrsServer.this.setupHandlers(ch, dispatcher, RestEasyHttpRequestDecoder.Protocol.HTTP);
                }
            };
        }
        if (this.sniConfiguration == null) {
            final SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            return new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addFirst(new ChannelHandler[]{new SslHandler(engine)});
                    NettyJaxrsServer.this.setupHandlers(ch, dispatcher, RestEasyHttpRequestDecoder.Protocol.HTTPS);
                }
            };
        }
        return new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addFirst(new ChannelHandler[]{new SniHandler(NettyJaxrsServer.this.sniConfiguration.buildMapping())});
                NettyJaxrsServer.this.setupHandlers(ch, dispatcher, RestEasyHttpRequestDecoder.Protocol.HTTPS);
            }
        };
    }

    private void setupHandlers(SocketChannel ch, RequestDispatcher dispatcher, RestEasyHttpRequestDecoder.Protocol protocol) {
        ChannelPipeline channelPipeline = ch.pipeline();
        channelPipeline.addLast(this.channelHandlers.toArray(new ChannelHandler[this.channelHandlers.size()]));
        channelPipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder(this.maxInitialLineLength, this.maxHeaderSize, this.maxChunkSize)});
        channelPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.maxRequestSize)});
        channelPipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        channelPipeline.addLast(this.httpChannelHandlers.toArray(new ChannelHandler[this.httpChannelHandlers.size()]));
        channelPipeline.addLast(new ChannelHandler[]{new RestEasyHttpRequestDecoder(dispatcher.getDispatcher(), this.root, protocol)});
        channelPipeline.addLast(new ChannelHandler[]{new RestEasyHttpResponseEncoder()});
        if (this.idleTimeout > 0) {
            channelPipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, this.idleTimeout));
        }
        channelPipeline.addLast((EventExecutorGroup)this.eventExecutor, new ChannelHandler[]{new RequestHandler(dispatcher)});
    }

    public void stop() {
        this.runtimePort = -1;
        this.eventLoopGroup.shutdownGracefully();
        this.eventExecutor.shutdownGracefully();
    }
}

