/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.server.netty.NettyHttpRequest;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.RequestDispatcher;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;

@ChannelHandler.Sharable
public class RequestHandler
extends SimpleChannelInboundHandler {
    protected final RequestDispatcher dispatcher;
    private static final Logger logger = Logger.getLogger(RequestHandler.class);

    public RequestHandler(RequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof NettyHttpRequest) {
            NettyHttpRequest request = (NettyHttpRequest)((Object)msg);
            if (request.is100ContinueExpected()) {
                this.send100Continue(ctx);
            }
            NettyHttpResponse response = request.getResponse();
            try {
                this.dispatcher.service(ctx, (HttpRequest)request, response, true);
            }
            catch (Failure e1) {
                response.reset();
                response.setStatus(e1.getErrorCode());
            }
            catch (Exception ex) {
                response.reset();
                response.setStatus(500);
                logger.error("Unexpected", (Throwable)ex);
            }
            if (!request.getAsyncContext().isSuspended()) {
                response.finish();
            }
        }
    }

    private void send100Continue(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.writeAndFlush((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        if (e.getCause() instanceof TooLongFrameException) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            e.getCause().printStackTrace();
            ctx.close();
        }
    }
}

