/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.plugins.server.netty.i18n.Messages;
import org.jboss.resteasy.spi.AsynchronousResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.util.Encode;

public class NettyHttpRequest
implements HttpRequest {
    protected HttpHeaders httpHeaders;
    protected CountDownLatch latch;
    protected long suspendTimeout;
    protected SynchronousDispatcher dispatcher;
    protected boolean suspended;
    protected UriInfo uri;
    protected String httpMethod;
    protected String preProcessedPath;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected AbstractAsynchronousResponse asynchronousResponse;
    protected InputStream inputStream;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected NettyHttpResponse httpResponse;
    private final boolean is100ContinueExpected;

    public NettyHttpRequest(HttpHeaders httpHeaders, UriInfo uri, String httpMethod, SynchronousDispatcher dispatcher, NettyHttpResponse httpResponse, boolean is100ContinueExpected) {
        this.is100ContinueExpected = is100ContinueExpected;
        this.httpResponse = httpResponse;
        this.dispatcher = dispatcher;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.preProcessedPath = uri.getPath(false);
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm((InputStream)this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException(Messages.MESSAGES.requestMediaType());
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    public UriInfo getUri() {
        return this.uri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getPreprocessedPath() {
        return this.preProcessedPath;
    }

    public void setPreprocessedPath(String path) {
        this.preProcessedPath = path;
    }

    public AsynchronousResponse createAsynchronousResponse(long suspendTimeout) {
        this.suspended = true;
        this.latch = new CountDownLatch(1);
        this.suspendTimeout = suspendTimeout;
        this.asynchronousResponse = new AbstractAsynchronousResponse(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setResponse(Response response) {
                try {
                    this.setupResponse((ServerResponse)response);
                    NettyHttpRequest.this.dispatcher.asynchronousDelivery((HttpRequest)NettyHttpRequest.this, (HttpResponse)NettyHttpRequest.this.httpResponse, response);
                }
                finally {
                    NettyHttpRequest.this.latch.countDown();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFailure(Exception ex) {
                try {
                    NettyHttpRequest.this.dispatcher.asynchronousDelivery((HttpRequest)NettyHttpRequest.this, (HttpResponse)NettyHttpRequest.this.httpResponse, ex);
                }
                finally {
                    NettyHttpRequest.this.latch.countDown();
                }
            }
        };
        return this.asynchronousResponse;
    }

    public AsynchronousResponse getAsynchronousResponse() {
        return this.asynchronousResponse;
    }

    public boolean isInitial() {
        return true;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void initialRequestThreadFinished() {
        if (this.latch == null) {
            return;
        }
        try {
            this.latch.await(this.suspendTimeout + 100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public NettyHttpResponse getResponse() {
        return this.httpResponse;
    }

    public boolean isKeepAlive() {
        return this.httpResponse.isKeepAlive();
    }

    public boolean is100ContinueExpected() {
        return this.is100ContinueExpected;
    }
}

