/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jsonp;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;

public class AbstractJsonpProvider {
    @Context
    Providers providers;

    public static Charset getCharset(MediaType mediaType) {
        String charset;
        if (mediaType != null && (charset = (String)mediaType.getParameters().get("charset")) != null) {
            return Charset.forName(charset);
        }
        return null;
    }

    protected JsonReader findReader(MediaType mediaType, InputStream is) {
        Charset charset;
        ContextResolver resolver = this.providers.getContextResolver(JsonReaderFactory.class, mediaType);
        JsonReaderFactory factory = null;
        if (resolver != null) {
            factory = (JsonReaderFactory)resolver.getContext(JsonReaderFactory.class);
        }
        if (factory == null) {
            factory = Json.createReaderFactory(null);
        }
        return (charset = AbstractJsonpProvider.getCharset(mediaType)) == null ? factory.createReader(is) : factory.createReader(is, charset);
    }

    protected JsonWriter findWriter(MediaType mediaType, OutputStream os) {
        Charset charset;
        ContextResolver resolver = this.providers.getContextResolver(JsonWriterFactory.class, mediaType);
        JsonWriterFactory factory = null;
        if (resolver != null) {
            factory = (JsonWriterFactory)resolver.getContext(JsonWriterFactory.class);
        }
        if (factory == null) {
            factory = Json.createWriterFactory(null);
        }
        return (charset = AbstractJsonpProvider.getCharset(mediaType)) == null ? factory.createWriter(os) : factory.createWriter(os, charset);
    }
}

