/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedJaxrsServer;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.plugins.server.sun.http.HttpContextBuilder;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.util.EmbeddedServerHelper;
import org.jboss.resteasy.util.PortProvider;

public class SunHttpJaxrsServer
implements EmbeddedJaxrsServer<SunHttpJaxrsServer> {
    protected HttpContextBuilder context = new HttpContextBuilder();
    protected HttpServer httpServer;
    protected int configuredPort = PortProvider.getPort();
    protected int runtimePort = -1;
    protected ResteasyDeployment deployment;
    private EmbeddedServerHelper serverHelper = new EmbeddedServerHelper();

    public SunHttpJaxrsServer deploy() {
        return this;
    }

    public SunHttpJaxrsServer start() {
        this.serverHelper.checkDeployment(this.deployment);
        String aPath = this.serverHelper.checkAppDeployment(this.deployment);
        if (aPath == null) {
            aPath = this.context.getPath();
        }
        this.setRootResourcePath(this.serverHelper.checkContextPath(aPath));
        if (this.httpServer == null) {
            try {
                this.httpServer = HttpServer.create(new InetSocketAddress(this.configuredPort), 10);
                this.runtimePort = this.httpServer.getAddress().getPort();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.context.bind(this.httpServer);
        this.httpServer.start();
        return this;
    }

    public void stop() {
        this.runtimePort = -1;
        this.httpServer.stop(10);
        this.context.cleanup();
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    public ResteasyDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = this.context.getDeployment();
        }
        return this.deployment;
    }

    public SunHttpJaxrsServer setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
        this.context.setDeployment(deployment);
        return this;
    }

    public SunHttpJaxrsServer setPort(int port) {
        this.configuredPort = port;
        return this;
    }

    public int getPort() {
        return this.runtimePort > 0 ? this.runtimePort : this.configuredPort;
    }

    public SunHttpJaxrsServer setHostname(String hostname) {
        return this;
    }

    public SunHttpJaxrsServer setSecurityDomain(SecurityDomain securityDomain) {
        this.context.setSecurityDomain(securityDomain);
        return this;
    }

    public SunHttpJaxrsServer setRootResourcePath(String rootResourcePath) {
        this.context.setPath(rootResourcePath);
        return this;
    }

    public SunHttpJaxrsServer setHttpServer(HttpServer httpServer) {
        this.httpServer = httpServer;
        return this;
    }
}

