/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.SynchronousExecutionContext;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.plugins.server.sun.http.HttpExchangeUtil;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public class HttpServerRequest
extends BaseHttpRequest {
    protected HttpExchange exchange;
    protected ResteasyHttpHeaders httpHeaders;
    protected ResteasyUriInfo uriInfo;
    protected String preProcessedPath;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected String httpMethod;

    public HttpServerRequest(SynchronousDispatcher dispatcher, HttpResponse httpResponse, HttpExchange exchange) {
        super(dispatcher);
        this.httpResponse = httpResponse;
        this.exchange = exchange;
        this.uriInfo = HttpExchangeUtil.extractUriInfo(exchange);
        this.httpHeaders = HttpExchangeUtil.extractHttpHeaders(exchange);
        this.preProcessedPath = this.uriInfo.getPath(false);
        this.httpMethod = exchange.getRequestMethod().toUpperCase();
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.uriInfo = this.uriInfo.setRequestUri(requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.uriInfo = new ResteasyUriInfo(baseUri.resolve(requestUri));
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.exchange.getRequestBody();
    }

    public void setInputStream(InputStream stream) {
        this.exchange.setStreams(stream, this.exchange.getResponseBody());
    }

    public ResteasyUriInfo getUri() {
        return this.uriInfo;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public Object getAttribute(String attribute) {
        Object val = this.attributes.get(attribute);
        if (val != null) {
            return val;
        }
        return this.exchange.getAttribute(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        this.exchange.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
        this.exchange.setAttribute(name, null);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = HttpServerRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return new SynchronousExecutionContext(this.dispatcher, (HttpRequest)this, this.httpResponse);
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }
}

