/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.sun.http;

import com.sun.net.httpserver.HttpExchange;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.plugins.server.sun.http.HttpExchangeUtil;
import org.jboss.resteasy.spi.HttpResponse;

public class HttpServerRequest
extends BaseHttpRequest {
    protected HttpExchange exchange;
    protected HttpHeaders httpHeaders;
    protected UriInfo uriInfo;
    protected String preProcessedPath;
    protected InputStream inputStream;
    protected Map<String, Object> attributes = new HashMap<String, Object>();

    public HttpServerRequest(SynchronousDispatcher dispatcher, HttpResponse httpResponse, HttpExchange exchange) {
        super(dispatcher);
        this.httpResponse = httpResponse;
        this.exchange = exchange;
        this.uriInfo = HttpExchangeUtil.extractUriInfo(exchange);
        this.httpHeaders = HttpExchangeUtil.extractHttpHeaders(exchange);
        this.preProcessedPath = this.uriInfo.getPath(false);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.exchange.getRequestBody();
    }

    public void setInputStream(InputStream stream) {
        this.exchange.setStreams(stream, this.exchange.getResponseBody());
    }

    public UriInfo getUri() {
        return this.uriInfo;
    }

    public String getHttpMethod() {
        return this.exchange.getRequestMethod().toUpperCase();
    }

    public String getPreprocessedPath() {
        return this.preProcessedPath;
    }

    public void setPreprocessedPath(String path) {
        this.preProcessedPath = path;
    }

    public Object getAttribute(String attribute) {
        return this.exchange.getAttribute(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.exchange.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.exchange.setAttribute(name, null);
    }
}

