/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.jackson;

import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;

public class WhiteListPolymorphicTypeValidatorBuilder
extends BasicPolymorphicTypeValidator.Builder {
    private static final long serialVersionUID = 464558058341488449L;
    private static final String BASE_TYPE_PROP = "resteasy.jackson.deserialization.whitelist.allowIfBaseType.prefix";
    private static final String SUB_TYPE_PROP = "resteasy.jackson.deserialization.whitelist.allowIfSubType.prefix";

    public WhiteListPolymorphicTypeValidatorBuilder() {
        String allowIfSubType;
        String allowIfBaseType = this.getProperty(BASE_TYPE_PROP);
        if (allowIfBaseType != null) {
            StringTokenizer st = new StringTokenizer(allowIfBaseType, ",", false);
            while (st.hasMoreTokens()) {
                this.allowIfBaseType(st.nextToken());
            }
        }
        if ((allowIfSubType = this.getProperty(SUB_TYPE_PROP)) != null) {
            StringTokenizer st = new StringTokenizer(allowIfSubType, ",", false);
            while (st.hasMoreTokens()) {
                this.allowIfSubType(st.nextToken());
            }
        }
    }

    private String getProperty(final String propertyName) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(propertyName);
                }
            });
        }
        return System.getProperty(propertyName);
    }
}

