/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import java.lang.reflect.Type;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.logging.Logger;
import org.jboss.resteasy.plugins.guice.GuiceResourceFactory;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

public class ModuleProcessor {
    private static final Logger logger = Logger.getLogger(ModuleProcessor.class);
    private final Registry registry;
    private final ResteasyProviderFactory providerFactory;

    public ModuleProcessor(Registry registry, ResteasyProviderFactory providerFactory) {
        this.registry = registry;
        this.providerFactory = providerFactory;
    }

    public void processInjector(Injector injector) {
        for (Binding binding : injector.getBindings().values()) {
            Type type = binding.getKey().getTypeLiteral().getType();
            if (!(type instanceof Class)) continue;
            Class beanClass = (Class)type;
            if (GetRestful.isRootResource((Class)beanClass)) {
                GuiceResourceFactory resourceFactory = new GuiceResourceFactory(binding.getProvider(), beanClass);
                logger.info("registering factory for {0}", new Object[]{beanClass.getName()});
                this.registry.addResourceFactory((ResourceFactory)resourceFactory);
            }
            if (!beanClass.isAnnotationPresent(Provider.class)) continue;
            logger.info("registering provider instance for {0}", new Object[]{beanClass.getName()});
            this.providerFactory.registerProviderInstance(binding.getProvider().get());
        }
    }
}

