/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.core.basic;

import dev.resteasy.junit.extension.annotations.RestBootstrap;
import dev.resteasy.junit.extension.api.ConfigurationProvider;
import jakarta.inject.Inject;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Application;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import org.jboss.jandex.Index;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestResourceA;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestResourceB;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestSingletonA;
import org.jboss.resteasy.embedded.test.core.basic.resource.ApplicationTestSingletonB;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=ApplicationTestMappedApplication.class, configFactory=TestConfigurationProvider.class)
public class ApplicationMappedTest {
    private static final String CONTENT_ERROR_MESSAGE = "Wrong content of response";
    @Inject
    private Client client;

    @Test
    @Inject
    public void testMapped(URI uri) {
        WebTarget base = this.client.target(uri);
        String value = (String)base.path("resources/a").request().get(String.class);
        Assertions.assertEquals((Object)"a", (Object)value, (String)CONTENT_ERROR_MESSAGE);
        value = (String)base.path("resources/b").request().get(String.class);
        Assertions.assertEquals((Object)"b", (Object)value, (String)CONTENT_ERROR_MESSAGE);
        value = (String)base.path("singletons/a").request().get(String.class);
        Assertions.assertEquals((Object)"a", (Object)value, (String)CONTENT_ERROR_MESSAGE);
        value = (String)base.path("singletons/b").request().get(String.class);
        Assertions.assertEquals((Object)"b", (Object)value, (String)CONTENT_ERROR_MESSAGE);
    }

    public static class TestConfigurationProvider
    implements ConfigurationProvider {
        public SeBootstrap.Configuration getConfiguration() {
            Index index;
            try {
                index = Index.of((Class[])new Class[]{ApplicationTestResourceA.class, ApplicationTestResourceB.class, ApplicationTestSingletonA.class, ApplicationTestSingletonB.class});
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return SeBootstrap.Configuration.builder().property(ConfigurationOption.JANDEX_INDEX.key(), (Object)index).rootPath("/mapped").build();
        }
    }

    public static class ApplicationTestMappedApplication
    extends Application {
    }
}

