/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.core.interceptors.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

@Path(value="resource")
public class ReaderContextResource {
    public static final String HEADERNAME = "FILTER_HEADER";
    @Context
    private HttpHeaders headers;

    public static final String getName() {
        return "<resource>" + ReaderContextResource.class.getName() + "</resource>";
    }

    @POST
    @Path(value="postlist")
    public String postList(List<String> list) {
        return list.iterator().next();
    }

    @GET
    @Path(value="getlist")
    public Response getList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ReaderContextResource.getName());
        GenericEntity<ArrayList<String>> entity = new GenericEntity<ArrayList<String>>(list){};
        return this.buildResponse(entity);
    }

    @POST
    @Path(value="poststring")
    public Response postString(String string) {
        return this.buildResponse(string);
    }

    private Response buildResponse(Object content) {
        return this.buildResponse(content, MediaType.WILDCARD_TYPE);
    }

    private Response buildResponse(Object content, MediaType type) {
        List list = this.headers.getRequestHeader(HEADERNAME);
        String name = null;
        if (list != null && list.size() != 0) {
            name = (String)list.iterator().next();
        }
        Response.ResponseBuilder builder = Response.ok((Object)content, (MediaType)type).type(type);
        if (name != null) {
            builder.header(HEADERNAME, (Object)name);
        }
        return builder.build();
    }
}

