/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.embedded.test.providers.custom;

import dev.resteasy.junit.extension.annotations.RequestPath;
import dev.resteasy.junit.extension.annotations.RestBootstrap;
import dev.resteasy.junit.extension.api.ConfigurationProvider;
import jakarta.inject.Inject;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Set;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.embedded.test.providers.custom.resource.ReaderWriterResource;
import org.jboss.resteasy.embedded.test.providers.custom.resource.WriterNotBuiltinTestWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@RestBootstrap(value=TestApplication.class, configFactory=TestConfiguration.class)
public class WriterNotBuiltinTest {
    @Inject
    private Client client;

    @Test
    public void test1New(@RequestPath(value="/string") URI uri) throws Exception {
        Response response = this.client.target(uri).request().get();
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertEquals((Object)"text/plain;charset=UTF-8", (Object)response.getStringHeaders().getFirst((Object)"content-type"));
        Assertions.assertEquals((Object)"hello world", (Object)response.readEntity(String.class), (String)"Response contains wrong content");
        Assertions.assertTrue((boolean)WriterNotBuiltinTestWriter.used, (String)"Wrong MessageBodyWriter was used");
    }

    public static class TestConfiguration
    implements ConfigurationProvider {
        public SeBootstrap.Configuration getConfiguration() {
            return SeBootstrap.Configuration.builder().property(ConfigurationOption.REGISTER_BUILT_INS.key(), (Object)false).build();
        }
    }

    public static class TestApplication
    extends Application {
        public Set<Class<?>> getClasses() {
            return Set.of(ReaderWriterResource.class, WriterNotBuiltinTestWriter.class);
        }
    }
}

