/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import org.jboss.resteasy.annotations.security.doseta.Verifications;
import org.jboss.resteasy.annotations.security.doseta.Verify;
import org.jboss.resteasy.security.doseta.AbstractDigitalVerificationHeaderDecorator;
import org.jboss.resteasy.security.doseta.Verifier;

@Provider
@ConstrainedTo(value=RuntimeType.CLIENT)
public class ClientDigitalVerificationHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, FeatureContext configurable) {
        Verify verify = resourceInfo.getResourceMethod().getAnnotation(Verify.class);
        Verifications verifications = resourceInfo.getResourceClass().getAnnotation(Verifications.class);
        if (verify != null || verifications != null) {
            configurable.register((Object)new DigitalVerificationHeaderDecorator(verify, verifications));
        }
    }

    @Priority(value=3000)
    public static class DigitalVerificationHeaderDecorator
    extends AbstractDigitalVerificationHeaderDecorator
    implements ClientResponseFilter {
        public DigitalVerificationHeaderDecorator(Verify verify, Verifications verifications) {
            this.verify = verify;
            this.verifications = verifications;
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
            requestContext.setProperty(Verifier.class.getName(), (Object)this.create());
        }
    }
}

