/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import org.jboss.resteasy.annotations.security.doseta.Signed;
import org.jboss.resteasy.security.doseta.AbstractDigitalSigningHeaderDecorator;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@ConstrainedTo(value=ConstrainedTo.Type.SERVER)
public class ServerDigitalSigningHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, Configurable configurable) {
        Signed signed = resourceInfo.getResourceMethod().getAnnotation(Signed.class);
        if (signed == null) {
            signed = resourceInfo.getResourceClass().getAnnotation(Signed.class);
        }
        if (signed == null) {
            return;
        }
        configurable.register((Object)new DigitalSigningHeaderDecorator(signed));
    }

    @BindingPriority(value=5000)
    public static class DigitalSigningHeaderDecorator
    extends AbstractDigitalSigningHeaderDecorator
    implements ContainerResponseFilter {
        public DigitalSigningHeaderDecorator(Signed signed) {
            this.signed = signed;
        }

        public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
            KeyRepository repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            DKIMSignature header = this.createHeader(repository);
            responseContext.getHeaders().add((Object)"DKIM-Signature", (Object)header);
        }
    }
}

