/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.IOException;
import javax.ws.rs.BindingPriority;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Configurable;
import org.jboss.resteasy.annotations.security.doseta.Signed;
import org.jboss.resteasy.security.doseta.AbstractDigitalSigningHeaderDecorator;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@ConstrainedTo(value=ConstrainedTo.Type.CLIENT)
public class ClientDigitalSigningHeaderDecoratorFeature
implements DynamicFeature {
    public void configure(ResourceInfo resourceInfo, Configurable configurable) {
        Signed signed = resourceInfo.getResourceMethod().getAnnotation(Signed.class);
        if (signed == null) {
            signed = resourceInfo.getResourceClass().getAnnotation(Signed.class);
        }
        if (signed == null) {
            return;
        }
        configurable.register((Object)new DigitalSigningHeaderDecorator(signed));
    }

    @BindingPriority(value=5000)
    public static class DigitalSigningHeaderDecorator
    extends AbstractDigitalSigningHeaderDecorator
    implements ClientRequestFilter {
        public DigitalSigningHeaderDecorator(Signed signed) {
            this.signed = signed;
        }

        public void filter(ClientRequestContext requestContext) throws IOException {
            KeyRepository repository = (KeyRepository)requestContext.getProperty(KeyRepository.class.getName());
            if (repository == null) {
                repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            }
            DKIMSignature header = this.createHeader(repository);
            requestContext.getHeaders().add((Object)"DKIM-Signature", (Object)header);
        }
    }
}

