/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.annotations.interception.ClientInterceptor;
import org.jboss.resteasy.annotations.interception.DecoderPrecedence;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.interception.MessageBodyWriterContext;
import org.jboss.resteasy.spi.interception.MessageBodyWriterInterceptor;

@Provider
@ServerInterceptor
@ClientInterceptor
@DecoderPrecedence
public class DigitalSigningInterceptor
implements MessageBodyWriterInterceptor {
    public void write(MessageBodyWriterContext context) throws IOException, WebApplicationException {
        MultivaluedMap headers = context.getHeaders();
        if (!headers.containsKey((Object)"DKIM-Signature")) {
            context.proceed();
            return;
        }
        List signatures = (List)headers.get((Object)"DKIM-Signature");
        if (signatures == null || signatures.isEmpty()) {
            context.proceed();
            return;
        }
        ArrayList<DKIMSignature> list = new ArrayList<DKIMSignature>();
        for (Object obj : signatures) {
            if (!(obj instanceof DKIMSignature)) continue;
            list.add((DKIMSignature)obj);
        }
        if (list.isEmpty()) {
            context.proceed();
            return;
        }
        OutputStream old = context.getOutputStream();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            context.setOutputStream((OutputStream)baos);
            context.proceed();
            byte[] body = baos.toByteArray();
            for (DKIMSignature dosetaSignature : list) {
                this.sign(context, (MultivaluedMap<String, Object>)headers, body, dosetaSignature);
            }
            old.write(body);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to sign", e);
        }
        finally {
            context.setOutputStream(old);
        }
    }

    protected void sign(MessageBodyWriterContext context, MultivaluedMap<String, Object> headers, byte[] body, DKIMSignature dosetaSignature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        if (dosetaSignature.getBased64Signature() != null) {
            return;
        }
        PrivateKey privateKey = dosetaSignature.getPrivateKey();
        if (privateKey == null) {
            KeyRepository repository = (KeyRepository)context.getAttribute(KeyRepository.class.getName());
            if (repository == null) {
                repository = (KeyRepository)ResteasyProviderFactory.getContextData(KeyRepository.class);
            }
            if (repository == null) {
                throw new RuntimeException("Unable to locate a private key to sign message, repository is null.");
            }
            privateKey = repository.findPrivateKey(dosetaSignature);
            if (privateKey == null) {
                throw new RuntimeException("Unable to find key to sign message. Repository returned null. ");
            }
        }
        dosetaSignature.sign((Map)headers, body, privateKey);
    }
}

