/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientInvokerFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ClientProxy;
import org.jboss.resteasy.client.jaxrs.internal.proxy.MethodInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.ResteasyClientProxy;
import org.jboss.resteasy.client.jaxrs.internal.proxy.SubResourceInvoker;
import org.jboss.resteasy.util.IsHttpMethod;

public class ProxyBuilderImpl<T>
extends ProxyBuilder<T> {
    private static final Class<?>[] cClassArgArray = new Class[]{Class.class};
    private final Class<T> iface;
    private final WebTarget webTarget;
    private ClassLoader loader = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    });
    private MediaType serverConsumes;
    private MediaType serverProduces;

    private static <T> ClientInvoker createClientInvoker(Class<T> clazz, Method method, ResteasyWebTarget base, ProxyConfig config) {
        Set httpMethods = IsHttpMethod.getHttpMethods((Method)method);
        if (httpMethods == null || httpMethods.size() != 1) {
            throw new RuntimeException(Messages.MESSAGES.mustUseExactlyOneHttpMethod(method.toString()));
        }
        ClientInvoker invoker = new ClientInvoker(base, clazz, method, config);
        invoker.setHttpMethod((String)httpMethods.iterator().next());
        return invoker;
    }

    public ProxyBuilderImpl(Class<T> iface, WebTarget webTarget) {
        this.iface = iface;
        this.webTarget = webTarget;
    }

    public ProxyBuilderImpl<T> classloader(ClassLoader cl) {
        this.loader = cl;
        return this;
    }

    public ProxyBuilderImpl<T> defaultProduces(MediaType type) {
        this.serverProduces = type;
        return this;
    }

    public ProxyBuilderImpl<T> defaultConsumes(MediaType type) {
        this.serverConsumes = type;
        return this;
    }

    public ProxyBuilderImpl<T> defaultProduces(String type) {
        this.serverProduces = MediaType.valueOf((String)type);
        return this;
    }

    public ProxyBuilderImpl<T> defaultConsumes(String type) {
        this.serverConsumes = MediaType.valueOf((String)type);
        return this;
    }

    public T build() {
        return this.build(new ProxyConfig(this.loader, this.serverConsumes, this.serverProduces));
    }

    public T build(ProxyConfig config) {
        Path path;
        WebTarget base = this.webTarget;
        if (this.iface.isAnnotationPresent(Path.class) && !(path = this.iface.getAnnotation(Path.class)).value().equals("") && !path.value().equals("/")) {
            base = base.path(path.value());
        }
        HashMap<Method, MethodInvoker> methodMap = new HashMap<Method, MethodInvoker>();
        for (Method method : this.iface.getMethods()) {
            MethodInvoker invoker;
            if ("as".equals(method.getName()) && Arrays.equals(method.getParameterTypes(), cClassArgArray)) continue;
            Set httpMethods = IsHttpMethod.getHttpMethods((Method)method);
            if ((httpMethods == null || httpMethods.size() == 0) && method.isAnnotationPresent(Path.class) && method.getReturnType().isInterface()) {
                invoker = new SubResourceInvoker((ResteasyWebTarget)base, method, config);
            } else {
                if (httpMethods == null) continue;
                invoker = base instanceof ClientInvokerFactory ? ((ClientInvokerFactory)base).createClientInvoker(this.iface, method, config) : ProxyBuilderImpl.createClientInvoker(this.iface, method, (ResteasyWebTarget)base, config);
            }
            methodMap.put(method, invoker);
        }
        Class[] intfs = new Class[]{this.iface, ResteasyClientProxy.class};
        ClientProxy clientProxy = new ClientProxy(methodMap, base, config);
        clientProxy.setClazz(this.iface);
        return (T)Proxy.newProxyInstance(config.getLoader(), intfs, (InvocationHandler)clientProxy);
    }
}

