/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.processors.invocation;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilderInterface;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.InvocationProcessor;

public class URIParamProcessor
implements InvocationProcessor {
    @Override
    public void process(ClientInvocationBuilderInterface invocation, Object param) {
        URI uri = this.getUri(param);
        if (uri != null) {
            invocation.getInvocation().setUri(uri);
        }
    }

    private URI getUri(Object target) {
        try {
            if (target instanceof URI) {
                return (URI)target;
            }
            if (target instanceof URL) {
                return ((URL)target).toURI();
            }
            if (target instanceof String) {
                return new URI(target.toString());
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

