/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.RedirectionException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.AsyncInvoker;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.internal.AsynchronousInvoke;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;

public class ClientInvocationBuilder
implements Invocation.Builder {
    protected ClientInvocation invocation;

    public ClientInvocationBuilder(ResteasyClient client, URI uri, ClientConfiguration configuration) {
        this.invocation = new ClientInvocation(client, uri, new ClientRequestHeaders(configuration), configuration);
    }

    public ClientInvocation getInvocation() {
        return this.invocation;
    }

    public ClientRequestHeaders getHeaders() {
        return this.invocation.headers;
    }

    public Invocation.Builder acceptLanguage(Locale ... locales) {
        this.getHeaders().acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptLanguage(String ... locales) {
        this.getHeaders().acceptLanguage(locales);
        return this;
    }

    public Invocation.Builder acceptEncoding(String ... encodings) {
        this.getHeaders().acceptEncoding(encodings);
        return this;
    }

    public Invocation.Builder cookie(Cookie cookie) {
        this.getHeaders().cookie(cookie);
        return this;
    }

    public Invocation.Builder cookie(String name, String value) {
        this.getHeaders().cookie(new Cookie(name, value));
        return this;
    }

    public Invocation.Builder cacheControl(CacheControl cacheControl) {
        this.getHeaders().cacheControl(cacheControl);
        return this;
    }

    public Invocation.Builder header(String name, Object value) {
        this.getHeaders().header(name, value);
        return this;
    }

    public Invocation.Builder headers(MultivaluedMap<String, Object> headers) {
        this.getHeaders().setHeaders(headers);
        return this;
    }

    public Invocation build(String method) {
        this.invocation.setMethod(method);
        return this.invocation;
    }

    public Invocation build(String method, Entity<?> entity) {
        this.invocation.setMethod(method);
        this.invocation.setEntity(entity);
        return this.invocation;
    }

    public Invocation buildGet() {
        return this.build("GET");
    }

    public Invocation buildDelete() {
        return this.build("DELETE");
    }

    public Invocation buildPost(Entity<?> entity) {
        return this.build("POST", entity);
    }

    public Invocation buildPut(Entity<?> entity) {
        return this.build("PUT", entity);
    }

    public AsyncInvoker async() {
        return new AsynchronousInvoke(this.invocation);
    }

    public Response get() {
        return this.buildGet().invoke();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T extractResult(GenericType<T> responseType, Response response, Annotation[] annotations) {
        int status = response.getStatus();
        if (status >= 200 && status < 300) {
            try {
                if (response.getMediaType() == null) {
                    T t = null;
                    return t;
                }
                Object object = response.readEntity(responseType, annotations);
                return (T)object;
            }
            finally {
                response.close();
            }
        }
        try {
            if (status >= 300 && status < 400) {
                throw new RedirectionException(response);
            }
            T t = ClientInvocationBuilder.handleErrorStatus(response);
            return t;
        }
        finally {
            if (response.getMediaType() == null) {
                response.close();
            }
        }
    }

    public static <T> T handleErrorStatus(Response response) {
        int status = response.getStatus();
        switch (status) {
            case 400: {
                throw new BadRequestException(response);
            }
            case 401: {
                throw new NotAuthorizedException(response);
            }
            case 404: {
                throw new NotFoundException(response);
            }
            case 405: {
                throw new NotAllowedException(response);
            }
            case 406: {
                throw new NotAcceptableException(response);
            }
            case 415: {
                throw new NotSupportedException(response);
            }
            case 500: {
                throw new InternalServerErrorException(response);
            }
            case 503: {
                throw new ServiceUnavailableException(response);
            }
        }
        if (status >= 400 && status < 500) {
            throw new ClientErrorException(response);
        }
        if (status >= 500) {
            throw new ServerErrorException(response);
        }
        throw new WebApplicationException(response);
    }

    public <T> T get(Class<T> responseType) {
        Response response = this.get();
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T get(GenericType<T> responseType) {
        return ClientInvocationBuilder.extractResult(responseType, this.get(), null);
    }

    public Response put(Entity<?> entity) {
        return this.buildPut(entity).invoke();
    }

    public <T> T put(Entity<?> entity, Class<T> responseType) {
        Response response = this.put(entity);
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T put(Entity<?> entity, GenericType<T> responseType) {
        Response response = this.put(entity);
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Response post(Entity<?> entity) {
        return this.buildPost(entity).invoke();
    }

    public <T> T post(Entity<?> entity, Class<T> responseType) {
        Response response = this.post(entity);
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T post(Entity<?> entity, GenericType<T> responseType) {
        Response response = this.post(entity);
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Response delete() {
        return this.buildDelete().invoke();
    }

    public <T> T delete(Class<T> responseType) {
        Response response = this.delete();
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T delete(GenericType<T> responseType) {
        Response response = this.delete();
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Response head() {
        return this.build("HEAD").invoke();
    }

    public Response options() {
        return this.build("OPTIONS").invoke();
    }

    public <T> T options(Class<T> responseType) {
        Response response = this.options();
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T options(GenericType<T> responseType) {
        Response response = this.options();
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Response trace() {
        return this.build("TRACE").invoke();
    }

    public <T> T trace(Class<T> responseType) {
        Response response = this.trace();
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T trace(GenericType<T> responseType) {
        Response response = this.trace();
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Response method(String name) {
        return this.build(name).invoke();
    }

    public <T> T method(String name, Class<T> responseType) {
        Response response = this.method(name);
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T method(String name, GenericType<T> responseType) {
        Response response = this.method(name);
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Response method(String name, Entity<?> entity) {
        return this.build(name, entity).invoke();
    }

    public <T> T method(String name, Entity<?> entity, Class<T> responseType) {
        Response response = this.method(name, entity);
        return ClientInvocationBuilder.extractResult(new GenericType(responseType), response, null);
    }

    public <T> T method(String name, Entity<?> entity, GenericType<T> responseType) {
        Response response = this.method(name, entity);
        return ClientInvocationBuilder.extractResult(responseType, response, null);
    }

    public Invocation.Builder property(String name, Object value) {
        this.invocation.property(name, value);
        return this;
    }

    public Invocation.Builder register(Class<?> componentClass) {
        this.invocation.register(componentClass);
        return this;
    }

    public Invocation.Builder register(Class<?> componentClass, int priority) {
        this.invocation.register(componentClass, priority);
        return this;
    }

    public Invocation.Builder register(Class<?> componentClass, Class<?> ... contracts) {
        this.invocation.register(componentClass, contracts);
        return this;
    }

    public Invocation.Builder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.invocation.register(componentClass, contracts);
        return this;
    }

    public Invocation.Builder register(Object component) {
        this.invocation.register(component);
        return this;
    }

    public Invocation.Builder register(Object component, int priority) {
        this.invocation.register(component, priority);
        return this;
    }

    public Invocation.Builder register(Object component, Class<?> ... contracts) {
        this.invocation.register(component, contracts);
        return this;
    }

    public Invocation.Builder register(Object component, Map<Class<?>, Integer> contracts) {
        this.invocation.register(component, contracts);
        return this;
    }

    public Invocation.Builder replaceWith(Configuration config) {
        this.invocation.replaceWith(config);
        return this;
    }

    public Configuration getConfiguration() {
        return this.invocation.getConfiguration();
    }
}

