/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.MessageProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.ext.ReaderInterceptor;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.core.interception.ClientReaderInterceptorContext;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.MarshalledEntity;
import org.jboss.resteasy.spi.ReaderException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.InputStreamToByteArray;
import org.jboss.resteasy.util.ReadFromStream;
import org.jboss.resteasy.util.Types;

public abstract class ClientResponse
extends BuiltResponse {
    protected Map<String, Object> properties;
    protected ClientConfiguration configuration;
    protected boolean isClosed;
    protected byte[] bufferedEntity;

    protected ClientResponse(ClientConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    public void setHeaders(MultivaluedMap<String, String> headers) {
        this.metadata = new Headers();
        this.metadata.putAll(headers);
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setConfiguration(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.processor = configuration;
    }

    public boolean hasEntity() {
        return this.entity != null || this.getMediaType() != null;
    }

    public void close() throws MessageProcessingException {
        if (this.isClosed) {
            return;
        }
        this.releaseConnection();
    }

    protected void finalize() throws Throwable {
        if (this.isClosed) {
            return;
        }
        this.releaseConnection();
    }

    protected abstract InputStream getInputStream();

    protected InputStream getEntityStream() {
        if (this.bufferedEntity != null) {
            return new ByteArrayInputStream(this.bufferedEntity);
        }
        if (this.isClosed) {
            throw new MessageProcessingException("Stream is closed");
        }
        return this.getInputStream();
    }

    protected abstract void setInputStream(InputStream var1);

    protected abstract void releaseConnection();

    public <T> T readEntity(Class<T> type, Type genericType, Annotation[] anns) {
        if (this.entity != null) {
            if (type.isInstance(this.entity)) {
                return (T)this.entity;
            }
            if (this.entity instanceof InputStream) {
                this.setInputStream((InputStream)this.entity);
                this.entity = null;
            } else {
                if (this.bufferedEntity == null) {
                    throw new RuntimeException("The entity was already read, and it was of type " + this.entity.getClass());
                }
                this.entity = null;
            }
        }
        if (this.entity == null) {
            if (this.status == 204) {
                return null;
            }
            try {
                this.entity = this.readFrom(type, genericType, this.getMediaType(), anns);
                if (this.entity != null && !InputStream.class.isInstance(this.entity)) {
                    this.close();
                }
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
        }
        return (T)this.entity;
    }

    protected <T> Object readFrom(Class<T> type, Type genericType, MediaType media, Annotation[] annotations) {
        MessageBodyReader<T> reader1;
        Type useGeneric = genericType == null ? type : genericType;
        Class useType = type;
        boolean isMarshalledEntity = false;
        if (type.equals(MarshalledEntity.class)) {
            isMarshalledEntity = true;
            ParameterizedType param = (ParameterizedType)useGeneric;
            useGeneric = param.getActualTypeArguments()[0];
            useType = Types.getRawType(useGeneric);
        }
        if ((reader1 = this.configuration.getMessageBodyReader(useType, useGeneric, annotations, media)) == null) {
            throw new MessageProcessingException(String.format("Unable to find a MessageBodyReader of content-type %s and type %s", media, useType));
        }
        Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
        ResteasyProviderFactory.pushContext(Providers.class, (Object)this.configuration);
        try {
            InputStream is = this.getEntityStream();
            if (is == null) {
                throw new MessageProcessingException("Input stream was empty, there is no entity");
            }
            if (isMarshalledEntity) {
                is = new InputStreamToByteArray(is);
            }
            ReaderInterceptor[] readerInterceptors = this.configuration.getReaderInterceptors(null, null);
            final Object obj = new ClientReaderInterceptorContext(readerInterceptors, reader1, useType, useGeneric, this.annotations, media, this.getStringHeaders(), is, this.properties).proceed();
            if (isMarshalledEntity) {
                InputStreamToByteArray isba = (InputStreamToByteArray)is;
                final byte[] bytes = isba.toByteArray();
                MarshalledEntity marshalledEntity = new MarshalledEntity(){

                    public byte[] getMarshalledBytes() {
                        return bytes;
                    }

                    public Object getEntity() {
                        return obj;
                    }
                };
                return marshalledEntity;
            }
            Object object = obj;
            return object;
        }
        catch (Exception e) {
            if (e instanceof ReaderException) {
                throw (ReaderException)e;
            }
            throw new ReaderException((Throwable)e);
        }
        finally {
            ResteasyProviderFactory.popContextData(Providers.class);
            if (current != null) {
                ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
            }
        }
    }

    public boolean bufferEntity() throws MessageProcessingException {
        if (this.bufferedEntity != null) {
            return true;
        }
        if (this.entity != null) {
            return false;
        }
        if (this.metadata.getFirst("Content-Type") == null) {
            return false;
        }
        try {
            this.bufferedEntity = ReadFromStream.readFromStream((int)1024, (InputStream)this.getInputStream());
        }
        catch (IOException e) {
            throw new MessageProcessingException((Throwable)e);
        }
        return true;
    }
}

