/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.jboss.resteasy.client.jaxrs.ProxyBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.specimpl.UriBuilderImpl;

public class ClientWebTarget
implements ResteasyWebTarget {
    protected ResteasyClient client;
    protected UriBuilder uriBuilder;
    protected ClientConfiguration configuration;

    protected ClientWebTarget(ResteasyClient client, ClientConfiguration configuration) {
        this.configuration = new ClientConfiguration(configuration);
        this.client = client;
    }

    public ClientWebTarget(ResteasyClient client, String uri, ClientConfiguration configuration) throws IllegalArgumentException, NullPointerException {
        this(client, configuration);
        this.uriBuilder = UriBuilder.fromUri((String)uri);
    }

    public ClientWebTarget(ResteasyClient client, URI uri, ClientConfiguration configuration) throws NullPointerException {
        this(client, configuration);
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
    }

    public ClientWebTarget(ResteasyClient client, UriBuilder uriBuilder, ClientConfiguration configuration) throws NullPointerException {
        this(client, configuration);
        this.uriBuilder = uriBuilder.clone();
    }

    @Override
    public ResteasyWebTarget clone() {
        UriBuilder copy = this.uriBuilder.clone();
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    @Override
    public ResteasyClient getResteasyClient() {
        return this.client;
    }

    @Override
    public <T> T proxy(Class<T> proxyInterface) {
        return ProxyBuilder.builder(proxyInterface, this).build();
    }

    @Override
    public <T> ProxyBuilder<T> proxyBuilder(Class<T> proxyInterface) {
        return ProxyBuilder.builder(proxyInterface, this);
    }

    public URI getUri() {
        return this.uriBuilder.clone().build(new Object[0]);
    }

    public UriBuilder getUriBuilder() {
        return this.uriBuilder.clone();
    }

    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public ResteasyWebTarget path(String path) throws NullPointerException {
        UriBuilder copy = this.uriBuilder.clone().path(path);
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    @Override
    public ResteasyWebTarget path(Class<?> resource) throws IllegalArgumentException {
        UriBuilder copy = this.uriBuilder.clone().path(resource);
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    @Override
    public ResteasyWebTarget path(Method method) throws IllegalArgumentException {
        UriBuilder copy = this.uriBuilder.clone().path(method);
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    @Override
    public ResteasyWebTarget resolveTemplate(String name, Object value) throws NullPointerException {
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.resolveTemplate(name, (Object)val);
        ClientWebTarget target = new ClientWebTarget(this.client, copy, this.configuration);
        return target;
    }

    @Override
    public ResteasyWebTarget resolveTemplates(Map<String, Object> templateValues) throws NullPointerException {
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.resolveTemplates(vals);
        ClientWebTarget target = new ClientWebTarget(this.client, copy, this.configuration);
        return target;
    }

    @Override
    public ResteasyWebTarget resolveTemplate(String name, Object value, boolean encodeSlashInPath) throws NullPointerException {
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.resolveTemplate(name, (Object)val, encodeSlashInPath);
        ClientWebTarget target = new ClientWebTarget(this.client, copy, this.configuration);
        return target;
    }

    @Override
    public ResteasyWebTarget resolveTemplateFromEncoded(String name, Object value) throws NullPointerException {
        String val = this.configuration.toString(value);
        UriBuilder copy = this.uriBuilder.resolveTemplateFromEncoded(name, (Object)val);
        ClientWebTarget target = new ClientWebTarget(this.client, copy, this.configuration);
        return target;
    }

    @Override
    public ResteasyWebTarget resolveTemplatesFromEncoded(Map<String, Object> templateValues) throws NullPointerException {
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.resolveTemplatesFromEncoded(vals);
        ClientWebTarget target = new ClientWebTarget(this.client, copy, this.configuration);
        return target;
    }

    @Override
    public ResteasyWebTarget resolveTemplates(Map<String, Object> templateValues, boolean encodeSlashInPath) throws NullPointerException {
        HashMap<String, String> vals = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : templateValues.entrySet()) {
            String val = this.configuration.toString(entry.getValue());
            vals.put(entry.getKey(), val);
        }
        UriBuilder copy = this.uriBuilder.resolveTemplates(vals, encodeSlashInPath);
        ClientWebTarget target = new ClientWebTarget(this.client, copy, this.configuration);
        return target;
    }

    @Override
    public ResteasyWebTarget matrixParam(String name, Object ... values) throws NullPointerException {
        Object[] stringValues = this.toStringValues(values);
        UriBuilder copy = this.uriBuilder.clone().matrixParam(name, stringValues);
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    private String[] toStringValues(Object[] values) {
        String[] stringValues = new String[values.length];
        for (int i = 0; i < stringValues.length; ++i) {
            stringValues[i] = this.configuration.toString(values[i]);
        }
        return stringValues;
    }

    @Override
    public ResteasyWebTarget queryParam(String name, Object ... values) throws NullPointerException {
        Object[] stringValues = this.toStringValues(values);
        UriBuilder copy = this.uriBuilder.clone().queryParam(name, stringValues);
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    @Override
    public ResteasyWebTarget queryParams(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        UriBuilder copy = this.uriBuilder.clone();
        for (Map.Entry entry : parameters.entrySet()) {
            Object[] stringValues = this.toStringValues(((List)entry.getValue()).toArray());
            copy.queryParam((String)entry.getKey(), stringValues);
        }
        return new ClientWebTarget(this.client, copy, this.configuration);
    }

    @Override
    public ResteasyWebTarget queryParamNoTemplate(String name, Object ... values) throws NullPointerException {
        String[] stringValues = this.toStringValues(values);
        UriBuilderImpl copy = (UriBuilderImpl)this.uriBuilder.clone();
        for (String obj : stringValues) {
            copy.clientQueryParam(name, (Object)obj);
        }
        return new ClientWebTarget(this.client, (UriBuilder)copy, this.configuration);
    }

    @Override
    public ResteasyWebTarget queryParamsNoTemplate(MultivaluedMap<String, Object> parameters) throws IllegalArgumentException, NullPointerException {
        UriBuilderImpl copy = (UriBuilderImpl)this.uriBuilder.clone();
        for (Map.Entry entry : parameters.entrySet()) {
            String[] stringValues;
            for (String val : stringValues = this.toStringValues(((List)entry.getValue()).toArray())) {
                copy.clientQueryParam((String)entry.getKey(), (Object)val);
            }
        }
        return new ClientWebTarget(this.client, (UriBuilder)copy, this.configuration);
    }

    public Invocation.Builder request() {
        return new ClientInvocationBuilder(this.client, this.uriBuilder.build(new Object[0]), this.configuration);
    }

    public Invocation.Builder request(String ... acceptedResponseTypes) {
        ClientInvocationBuilder builder = new ClientInvocationBuilder(this.client, this.uriBuilder.build(new Object[0]), this.configuration);
        builder.getHeaders().accept(acceptedResponseTypes);
        return builder;
    }

    public Invocation.Builder request(MediaType ... acceptedResponseTypes) {
        ClientInvocationBuilder builder = new ClientInvocationBuilder(this.client, this.uriBuilder.build(new Object[0]), this.configuration);
        builder.getHeaders().accept(acceptedResponseTypes);
        return builder;
    }
}

