/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines.vertx;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

@Deprecated(forRemoval=true, since="6.2.13.Final")
public class InputStreamAdapter
extends InputStream {
    private final Object lock = new Object();
    private final ReadStream<Buffer> stream;
    private Buffer pending = Buffer.buffer();
    private boolean paused;
    private boolean ended;
    private Throwable failure;
    private final long maxPendingSize;
    private byte[] buffer = new byte[1];

    public InputStreamAdapter(ReadStream<Buffer> stream) {
        this(stream, 256L);
    }

    public InputStreamAdapter(ReadStream<Buffer> stream, long maxPendingSize) {
        this.stream = stream;
        this.maxPendingSize = maxPendingSize;
        stream.handler(this::onChunk);
        stream.endHandler(this::onEnd);
        stream.exceptionHandler(this::onError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChunk(Buffer chunk) {
        Object object = this.lock;
        synchronized (object) {
            this.pending.appendBuffer(chunk);
            if ((long)this.pending.length() > this.maxPendingSize) {
                this.paused = true;
                this.stream.pause();
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnd(Void v) {
        Object object = this.lock;
        synchronized (object) {
            this.ended = true;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Throwable cause) {
        Object object = this.lock;
        synchronized (object) {
            this.failure = cause;
            this.ended = true;
            this.lock.notifyAll();
        }
    }

    @Override
    public int read() throws IOException {
        int val = this.read(this.buffer, 0, 1);
        if (val == -1) {
            return -1;
        }
        return this.buffer[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (len == 0) {
                if (!this.ended) {
                    return 0;
                }
                if (this.failure != null) {
                    throw new IOException(this.failure);
                }
                return -1;
            }
            while (true) {
                if (this.pending.length() > 0) {
                    int amount = Math.min(this.pending.length(), len);
                    this.pending.getBytes(0, amount, b);
                    this.pending = this.pending.getBuffer(amount, this.pending.length());
                    if ((long)this.pending.length() == 0L && this.paused) {
                        this.paused = false;
                        this.stream.resume();
                    }
                    return amount;
                }
                if (this.ended) {
                    if (this.failure != null) {
                        throw new IOException(this.failure);
                    }
                    return -1;
                }
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
        }
    }
}

