/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication.digest;

import dev.resteasy.client.util.common.ByteStringBuilder;
import dev.resteasy.client.util.common.Bytes;
import java.security.MessageDigest;

class DigestHashBuilder {
    private final MessageDigest md;
    private final ByteStringBuilder builder;
    private boolean prependColon;

    DigestHashBuilder(MessageDigest md) {
        this.md = md;
        this.builder = new ByteStringBuilder(256);
        this.prependColon = false;
    }

    DigestHashBuilder append(String value) {
        this.prepend();
        this.builder.append(value);
        return this;
    }

    DigestHashBuilder append(byte[] value) {
        this.prepend();
        this.builder.append(value);
        return this;
    }

    DigestHashBuilder append(Object value) {
        return this.append(String.valueOf(value));
    }

    String build() {
        this.prependColon = false;
        this.md.update(this.builder.toArray(true));
        try {
            String string = Bytes.bytesToHexString(this.md.digest());
            return string;
        }
        finally {
            this.md.reset();
        }
    }

    private void prepend() {
        if (this.prependColon) {
            this.builder.append(':');
        } else {
            this.prependColon = true;
        }
    }
}

