/*
 * Decompiled with CFR 0.152.
 */
package dev.resteasy.client.util.authentication;

import dev.resteasy.client.util.authentication.HttpAuthorizationFilter;
import dev.resteasy.client.util.authentication.UserCredentials;
import dev.resteasy.client.util.authentication.basic.BasicAuthorizationProcessor;
import dev.resteasy.client.util.authentication.digest.DigestAuthorizationProcessor;
import dev.resteasy.client.util.logging.ClientMessages;
import java.util.Objects;

public class HttpAuthenticators {
    public static HttpAuthorizationFilter basic(UserCredentials credentials) {
        return new HttpAuthorizationFilter(new BasicAuthorizationProcessor(Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"))));
    }

    public static HttpAuthorizationFilter basic(int limit, UserCredentials credentials) {
        return new HttpAuthorizationFilter(limit, new BasicAuthorizationProcessor(Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"))));
    }

    public static HttpAuthorizationFilter digest(UserCredentials credentials) {
        return new HttpAuthorizationFilter(new DigestAuthorizationProcessor(Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"))));
    }

    public static HttpAuthorizationFilter digest(int limit, UserCredentials credentials) {
        return new HttpAuthorizationFilter(limit, new DigestAuthorizationProcessor(Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials")), limit));
    }

    public static HttpAuthorizationFilter available(UserCredentials credentials) {
        Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"));
        return new HttpAuthorizationFilter(new BasicAuthorizationProcessor(credentials), new DigestAuthorizationProcessor(credentials));
    }

    public static HttpAuthorizationFilter available(int limit, UserCredentials credentials) {
        Objects.requireNonNull(credentials, ClientMessages.MESSAGES.requiredValue("credentials"));
        return new HttpAuthorizationFilter(limit, new BasicAuthorizationProcessor(credentials), new DigestAuthorizationProcessor(credentials));
    }
}

