/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.jaxrs.engines.AsyncClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.engines.ReactiveClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.TrackingClientRequestHeaders;
import org.jboss.resteasy.client.jaxrs.internal.TrackingMap;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.CaseInsensitiveMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;

public class ReactorNettyClientHttpEngine
implements ReactiveClientHttpEngine {
    private static final Logger log = Logger.getLogger(ReactorNettyClientHttpEngine.class);
    private final HttpClient httpClient;
    private final ChannelGroup channelGroup;
    private final ConnectionProvider connectionProvider;
    private final Optional<Duration> requestTimeout;
    private final BiFunction<ClientConfiguration, InputStream, ClientResponse> fnClientResponse;

    private ReactorNettyClientHttpEngine(HttpClient httpClient, ChannelGroup channelGroup, ConnectionProvider connectionProvider, Optional<Duration> requestTimeout, Boolean useFinalizedResponse) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.channelGroup = Objects.requireNonNull(channelGroup);
        this.connectionProvider = Objects.requireNonNull(connectionProvider);
        this.requestTimeout = Objects.requireNonNull(requestTimeout);
        requestTimeout.ifPresent(duration -> {
            if (duration.isNegative()) {
                throw new IllegalArgumentException("Required positive value for requestTimeout");
            }
            if (duration.isZero()) {
                throw new IllegalArgumentException("Required non zero value for requestTimeout");
            }
        });
        this.fnClientResponse = useFinalizedResponse != false ? (x$0, x$1) -> new FinalizedRestEasyClientResponse((ClientConfiguration)x$0, (InputStream)x$1) : RestEasyClientResponse::new;
    }

    public ReactorNettyClientHttpEngine(HttpClient httpClient, ChannelGroup channelGroup, ConnectionProvider connectionProvider) {
        this(httpClient, channelGroup, connectionProvider, Optional.empty(), (Boolean)false);
    }

    public ReactorNettyClientHttpEngine(HttpClient httpClient, ChannelGroup channelGroup, ConnectionProvider connectionProvider, Duration requestTimeout) {
        this(httpClient, channelGroup, connectionProvider, Optional.of(requestTimeout), (Boolean)false);
    }

    public ReactorNettyClientHttpEngine(HttpClient httpClient, ChannelGroup channelGroup, ConnectionProvider connectionProvider, Boolean useResponseFinalize) {
        this(httpClient, channelGroup, connectionProvider, Optional.empty(), useResponseFinalize);
    }

    public ReactorNettyClientHttpEngine(HttpClient httpClient, ChannelGroup channelGroup, ConnectionProvider connectionProvider, Duration requestTimeout, Boolean useResponseFinalize) {
        this(httpClient, channelGroup, connectionProvider, Optional.of(requestTimeout), useResponseFinalize);
    }

    public <T> Mono<T> submitRx(ClientInvocation request, boolean buffered, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        Mono responseMono = this.send(request).responseSingle((response, bytes) -> bytes.asInputStream().map(is -> this.toRestEasyResponse(request.getClientConfiguration(), (HttpClientResponse)response, (InputStream)is)).switchIfEmpty(Mono.defer(() -> Mono.just((Object)this.toRestEasyResponse(request.getClientConfiguration(), (HttpClientResponse)response, null)))).doOnDiscard(InputStream.class, is -> {
            try {
                is.close();
            }
            catch (IOException e) {
                log.warn((Object)"Not able to close InputStream.  This may lead to direct memory leaks", (Throwable)e);
            }
        }).doOnDiscard(RestEasyClientResponse.class, ClientResponse::close));
        return this.requestTimeout.map(arg_0 -> ((Mono)responseMono).timeout(arg_0)).orElse(responseMono).handle((response, sink) -> {
            try {
                sink.next(extractor.extractResult(response));
            }
            catch (Exception e) {
                try {
                    response.releaseConnection();
                }
                catch (IOException ie) {
                    log.warn((Object)"There was a problem releasing the connection in an error scenario.", (Throwable)ie);
                }
                sink.error((Throwable)e);
            }
        });
    }

    private HttpClient.ResponseReceiver<?> send(ClientInvocation resteasyReq) {
        Optional<Object> reqPayload = Optional.ofNullable(resteasyReq.getEntity());
        HttpClient.RequestSender requestSender = (HttpClient.RequestSender)this.httpClient.headers(headers -> ReactorNettyClientHttpEngine.addHeaders(resteasyReq, headers)).request(HttpMethod.valueOf((String)resteasyReq.getMethod())).uri(resteasyReq.getUri().toString());
        return reqPayload.map(ignore -> requestSender.send((reactorReq, outbound) -> {
            ByteBufOutputStream byteBufOutputStream = new ByteBufOutputStream(outbound.alloc().buffer());
            resteasyReq.setHeaders((ClientRequestHeaders)new TrackingClientRequestHeaders(resteasyReq.getClientConfiguration(), (CaseInsensitiveMap<Object>)resteasyReq.getHeaders().getHeaders()));
            try {
                ReactorNettyClientHttpEngine.sendRequestBody(resteasyReq, byteBufOutputStream);
            }
            catch (IOException ioe) {
                return Mono.error((Throwable)ioe);
            }
            TrackingMap trackingMap = (TrackingMap)resteasyReq.getHeaders().getHeaders();
            trackingMap.getAddedOrUpdatedKeys().forEach(key -> ReactorNettyClientHttpEngine.updateHeader(key, (CaseInsensitiveMap<Object>)resteasyReq.getHeaders().getHeaders(), reactorReq.requestHeaders()));
            trackingMap.getRemovedKeys().forEach(arg_0 -> ((HttpHeaders)reactorReq.requestHeaders()).remove(arg_0));
            int length = byteBufOutputStream.writtenBytes();
            reactorReq.header((CharSequence)"Content-Length", (CharSequence)Integer.toString(length));
            if (log.isDebugEnabled() && ReactorNettyClientHttpEngine.isContentLengthInvalid(resteasyReq.getHeaders().getHeader("Content-Length"), length)) {
                log.debug((Object)"The request's Content-Length header is replaced  by the size of the byte array computed from the request entity.");
            }
            return outbound.send((Publisher)Mono.defer(() -> Mono.just((Object)byteBufOutputStream.buffer())));
        })).orElse((HttpClient.ResponseReceiver)requestSender);
    }

    private static void addHeaders(ClientInvocation resteasyReq, HttpHeaders reactorHeaders) {
        ClientRequestHeaders resteasyHeaders = resteasyReq.getHeaders();
        resteasyHeaders.getHeaders().entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            List valueList = (List)entry.getValue();
            valueList.forEach(value -> reactorHeaders.add(key, value != null ? value : ""));
        });
    }

    private static void updateHeader(String key, CaseInsensitiveMap<Object> headers, HttpHeaders reactorHeaders) {
        List valueList = headers.get((Object)key);
        reactorHeaders.set(key, (Iterable)valueList);
    }

    public <T> Mono<T> fromCompletionStage(CompletionStage<T> cs) {
        return Mono.fromCompletionStage(() -> cs);
    }

    public <T> Mono<T> just(T t) {
        return Mono.just(t);
    }

    public Mono error(Exception e) {
        return Mono.error((Throwable)e);
    }

    public <T> Future<T> submit(ClientInvocation request, boolean buffered, InvocationCallback<T> callback, AsyncClientHttpEngine.ResultExtractor<T> extractor) {
        return this.submit(request, buffered, extractor, null).whenComplete((response, throwable) -> {
            if (callback != null) {
                if (throwable != null) {
                    callback.failed(throwable);
                } else {
                    callback.completed(response);
                }
            }
        });
    }

    public <K> CompletableFuture<K> submit(ClientInvocation request, boolean buffered, AsyncClientHttpEngine.ResultExtractor<K> extractor, ExecutorService executorService) {
        return this.submitRx(request, buffered, (AsyncClientHttpEngine.ResultExtractor<T>)((AsyncClientHttpEngine.ResultExtractor)extractor)).toFuture();
    }

    private static boolean isContentLengthInvalid(String headerValue, int length) {
        try {
            return headerValue != null && Long.parseLong(headerValue) != (long)length;
        }
        catch (Exception e) {
            log.warn((Object)"Problem parsing the Content-Length header value.", (Throwable)e);
            return true;
        }
    }

    public SSLContext getSslContext() {
        throw new UnsupportedOperationException();
    }

    public HostnameVerifier getHostnameVerifier() {
        throw new UnsupportedOperationException();
    }

    public Response invoke(Invocation request) {
        Future future = this.submit((ClientInvocation)request, false, null, response -> response);
        try {
            return (Response)future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw ReactorNettyClientHttpEngine.clientException(e, null);
        }
        catch (ExecutionException e) {
            throw ReactorNettyClientHttpEngine.clientException(e.getCause(), null);
        }
    }

    public void close() {
        try {
            this.channelGroup.close().await();
        }
        catch (InterruptedException e) {
            log.warn((Object)"Exception while closing Netty ChannelGroup", (Throwable)e);
        }
        finally {
            this.connectionProvider.disposeLater().block();
        }
    }

    static RuntimeException clientException(Throwable ex, Response clientResponse) {
        Object ret = ex == null ? new ProcessingException((Throwable)new NullPointerException()) : (ex instanceof WebApplicationException ? (WebApplicationException)ex : (ex instanceof ProcessingException ? (ProcessingException)ex : (clientResponse != null ? new ResponseProcessingException(clientResponse, ex) : new ProcessingException(ex))));
        return ret;
    }

    private static void sendRequestBody(ClientInvocation req, ByteBufOutputStream out) throws IOException {
        req.getDelegatingOutputStream().setDelegate((OutputStream)out);
        if (ResteasyContext.getContextData(Providers.class) == null) {
            try (ResteasyContext.CloseableContext cc = ReactorNettyClientHttpEngine.pushProvidersContext(req);){
                req.writeRequestBody(req.getEntityStream());
            }
        } else {
            req.writeRequestBody(req.getEntityStream());
        }
    }

    private static ResteasyContext.CloseableContext pushProvidersContext(ClientInvocation req) {
        ResteasyContext.CloseableContext ret = ResteasyContext.addCloseableContextDataLevel();
        ResteasyContext.pushContext(Providers.class, (Object)req.getClientConfiguration());
        return ret;
    }

    private ClientResponse toRestEasyResponse(ClientConfiguration clientConfiguration, HttpClientResponse reactorNettyResponse, InputStream inputStream) {
        ClientResponse restEasyClientResponse = this.fnClientResponse.apply(clientConfiguration, inputStream);
        restEasyClientResponse.setStatus(reactorNettyResponse.status().code());
        MultivaluedMap resteasyHeaders = restEasyClientResponse.getHeaders();
        reactorNettyResponse.responseHeaders().forEach(header -> resteasyHeaders.add((Object)((String)header.getKey()), header.getValue()));
        return restEasyClientResponse;
    }

    private class FinalizedRestEasyClientResponse
    extends RestEasyClientResponse {
        FinalizedRestEasyClientResponse(ClientConfiguration configuration, InputStream is) {
            super(configuration, is);
        }

        protected void finalize() throws Throwable {
            if (this.isClosed()) {
                return;
            }
            try {
                log.warn((Object)"RestEasyClientResponse was leaked. Ensure all resources are freed via calling close()");
                this.close();
            }
            catch (Exception e) {
                log.warn((Object)"Exception while close() during finalize()", (Throwable)e);
            }
        }
    }

    private static class RestEasyClientResponse
    extends ClientResponse {
        private InputStream is;

        RestEasyClientResponse(ClientConfiguration configuration, InputStream is) {
            super(configuration, RESTEasyTracingLogger.empty());
            this.is = is;
        }

        protected InputStream getInputStream() {
            return this.is;
        }

        protected void setInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public void releaseConnection() throws IOException {
            this.releaseConnection(false);
        }

        public void releaseConnection(boolean consumeInputStream) throws IOException {
            try {
                if (this.is != null) {
                    if (consumeInputStream) {
                        while (this.is.available() > 0) {
                            this.is.read();
                        }
                    }
                    this.is.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)"Exception while releasing the connection!", (Throwable)e);
            }
        }
    }
}

