/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.microprofile;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.microprofile.DefaultResponseExceptionMapper;
import org.jboss.resteasy.client.microprofile.MPResteasyClientBuilder;
import org.jboss.resteasy.client.microprofile.MPResteasyProviderFactory;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.specimpl.ResteasyUriBuilder;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

class MicroprofileClientBuilder
implements RestClientBuilder {
    private static final String DEFAULT_MAPPER_PROP = "microprofile.rest.client.disable.default.mapper";
    private final ResteasyClientBuilder builderDelegate;
    private URI baseURI;

    public MicroprofileClientBuilder() {
        MPResteasyProviderFactory rpf = new MPResteasyProviderFactory();
        RegisterBuiltin.register((ResteasyProviderFactory)rpf);
        this.builderDelegate = new MPResteasyClientBuilder().providerFactory(rpf);
    }

    public RestClientBuilder baseUrl(URL url) {
        try {
            this.baseURI = url.toURI();
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public <T> T build(Class<T> aClass) throws IllegalStateException, RestClientDefinitionException {
        RegisterProvider[] providers;
        this.verifyInterface(aClass);
        for (RegisterProvider provider : providers = (RegisterProvider[])aClass.getAnnotationsByType(RegisterProvider.class)) {
            this.builderDelegate.register(provider.value(), provider.priority());
        }
        boolean defaultMapperDisabled = false;
        Object defaultMapperProp = this.builderDelegate.getConfiguration().getProperty(DEFAULT_MAPPER_PROP);
        if (defaultMapperProp != null && defaultMapperProp.equals(Boolean.TRUE)) {
            defaultMapperDisabled = true;
        }
        if (!defaultMapperDisabled) {
            this.builderDelegate.register(DefaultResponseExceptionMapper.class);
        }
        ResteasyClient client = this.builderDelegate.build();
        return (T)client.target(this.baseURI).proxyBuilder(aClass).defaultConsumes("text/plain").defaultProduces("text/plain").build();
    }

    private <T> void verifyInterface(Class<T> typeDef) {
        Method[] methods;
        for (Method method : methods = typeDef.getMethods()) {
            boolean hasHttpMethod = false;
            Annotation[] annotationArray = method.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                boolean isHttpMethod;
                Annotation annotation = annotationArray[i];
                boolean bl = isHttpMethod = annotation.annotationType().getAnnotation(HttpMethod.class) != null;
                if (!hasHttpMethod && isHttpMethod) {
                    hasHttpMethod = true;
                    continue;
                }
                if (!hasHttpMethod || !isHttpMethod) continue;
                throw new RestClientDefinitionException("Ambiguous @Httpmethod defintion on type " + typeDef);
            }
        }
        Path classPathAnno = typeDef.getAnnotation(Path.class);
        HashSet classLevelVariables = new HashSet();
        ResteasyUriBuilder classTemplate = null;
        if (classPathAnno != null) {
            classTemplate = (ResteasyUriBuilder)UriBuilder.fromUri((String)classPathAnno.value());
            classLevelVariables.addAll(classTemplate.getPathParamNamesInDeclarationOrder());
        }
        for (Method method : methods) {
            Path methodPathAnno = method.getAnnotation(Path.class);
            ResteasyUriBuilder template = methodPathAnno != null ? (classPathAnno == null ? (ResteasyUriBuilder)UriBuilder.fromUri((String)methodPathAnno.value()) : (ResteasyUriBuilder)UriBuilder.fromUri((String)(classPathAnno.value() + "/" + methodPathAnno.value()))) : classTemplate;
            if (template == null) continue;
            template.host("localhost");
            HashSet allVariables = new HashSet(template.getPathParamNamesInDeclarationOrder());
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (Parameter p : method.getParameters()) {
                PathParam pathParam = p.getAnnotation(PathParam.class);
                if (pathParam == null) continue;
                paramMap.put(pathParam.value(), "foobar");
            }
            if (allVariables.size() != paramMap.size()) {
                throw new RestClientDefinitionException("Parameters and variables don't match on " + typeDef + "::" + method.getName());
            }
            try {
                template.resolveTemplates(paramMap, false).build(new Object[0]);
            }
            catch (IllegalArgumentException ex) {
                throw new RestClientDefinitionException("Parameter names don't match variable names on " + typeDef + "::" + method.getName(), (Throwable)ex);
            }
        }
    }

    public Configuration getConfiguration() {
        return this.builderDelegate.getConfiguration();
    }

    public RestClientBuilder property(String name, Object value) {
        this.builderDelegate.property(name, value);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass) {
        this.builderDelegate.register(aClass);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, int i) {
        this.builderDelegate.register(aClass, i);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Class<?>[] classes) {
        this.builderDelegate.register(aClass, (Class[])classes);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Map<Class<?>, Integer> map) {
        this.builderDelegate.register(aClass, map);
        return this;
    }

    public RestClientBuilder register(Object o) {
        this.builderDelegate.register(o);
        return this;
    }

    public RestClientBuilder register(Object o, int i) {
        this.builderDelegate.register(o, i);
        return this;
    }

    public RestClientBuilder register(Object o, Class<?>[] classes) {
        this.builderDelegate.register(o, (Class[])classes);
        return this;
    }

    public RestClientBuilder register(Object o, Map<Class<?>, Integer> map) {
        this.builderDelegate.register(o, map);
        return this;
    }
}

