/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.client.async;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class ExecutorServiceWrapper
implements ExecutorService {
    private final ExecutorService delegate;
    private final Decorator decorator;

    public ExecutorServiceWrapper(ExecutorService delegate, Decorator decorator) {
        this.delegate = delegate;
        this.decorator = decorator;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(this.decorate(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(this.decorate(task));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.decorate(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.decorate(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.decorate(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.decorate(tasks), timeout, unit);
    }

    private <T> Collection<Callable<T>> decorate(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::decorate).collect(Collectors.toList());
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(this.decorate(command));
    }

    private Runnable decorate(Runnable command) {
        return this.decorator.decorate(command);
    }

    private <T> Callable<T> decorate(Callable<T> command) {
        return this.decorator.decorate(command);
    }

    public static interface Decorator {
        public Runnable decorate(Runnable var1);

        public <T> Callable<T> decorate(Callable<T> var1);
    }
}

